/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.core;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;

public final class Version
implements Comparable<Version> {
    public static final String FORMAT_MINIMAL = "%d.%d";
    public static final String FORMAT_SHORT = "%d.%d.%s";
    public static final String FORMAT_LONG = "%d.%d.%s.%s";
    private static final String NEGATIVE = "Version segment cannot be negative";
    public static final String TOO_SHORT = "Version must have at least major and minor numbers";
    private final int major;
    private final int minor;
    private final String patch;
    private final String build;
    private final String format;

    private Version(int major, int minor, String patch, String build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.build = build;
        this.format = Strings.isNullOrEmpty((String)patch) ? String.format(FORMAT_MINIMAL, major, minor) : (Strings.isNullOrEmpty((String)build) ? String.format(FORMAT_SHORT, major, minor, patch) : String.format(FORMAT_LONG, major, minor, patch, build));
    }

    public static Version version(int major, int minor, String patch, String build) {
        Preconditions.checkArgument((major >= 0 ? 1 : 0) != 0, (Object)NEGATIVE);
        Preconditions.checkArgument((minor >= 0 ? 1 : 0) != 0, (Object)NEGATIVE);
        return new Version(major, minor, patch, build);
    }

    public static Version version(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0, (Object)TOO_SHORT);
        String[] fields = string.split("[.-]", 4);
        Preconditions.checkArgument((fields.length >= 2 ? 1 : 0) != 0, (Object)TOO_SHORT);
        return new Version(Integer.parseInt(fields[0]), Integer.parseInt(fields[1]), fields.length >= 3 ? fields[2] : null, fields.length >= 4 ? fields[3] : null);
    }

    public static Version fromInt(int version) {
        int major = version >> 24 & 0xFF;
        int minor = version >> 16 & 0xFF;
        int patch = version >> 8 & 0xFF;
        int build = version & 0xFF;
        return new Version(major, minor, String.valueOf(patch), String.valueOf(build));
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public String patch() {
        return this.patch;
    }

    public String build() {
        return this.build;
    }

    public int toInt() {
        byte build;
        byte patch;
        byte major = (byte)this.major;
        byte minor = (byte)this.minor;
        if (this.patch != null) {
            try {
                patch = (byte)Integer.parseInt(this.patch.replaceAll("[^0-9]", ""));
            }
            catch (NumberFormatException e) {
                patch = 0;
            }
        } else {
            patch = 0;
        }
        if (this.build != null) {
            try {
                build = (byte)Integer.parseInt(this.build.replaceAll("[^0-9]", ""));
            }
            catch (NumberFormatException e) {
                build = 0;
            }
        } else {
            build = 0;
        }
        return major << 24 | (minor & 0xFF) << 16 | (patch & 0xFF) << 8 | build & 0xFF;
    }

    @Override
    public int compareTo(Version other) {
        return Integer.compare(this.toInt(), other.toInt());
    }

    public String toString() {
        return this.format;
    }

    public int hashCode() {
        return this.format.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Version) {
            Version other = (Version)obj;
            return Objects.equals(this.format, other.format);
        }
        return false;
    }
}

