/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.trafficcontrol;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.trafficcontrol.Policer;
import org.onosproject.net.behaviour.trafficcontrol.PolicerEntry;
import org.onosproject.net.behaviour.trafficcontrol.PolicerId;
import org.onosproject.net.behaviour.trafficcontrol.PolicingResource;
import org.onosproject.net.behaviour.trafficcontrol.TokenBucket;

@Beta
public final class DefaultPolicer
implements Policer,
PolicerEntry {
    private final DeviceId deviceId;
    private final ApplicationId applicationId;
    private final PolicerId policerId;
    private final boolean colorAware;
    private final Policer.Unit unit;
    private final Collection<TokenBucket> tokenBuckets;
    private final String description;
    private long referenceCount;
    private long processedPackets;
    private long processedBytes;
    private long life;

    private DefaultPolicer(DeviceId dId, ApplicationId aId, PolicerId pId, boolean cA, Policer.Unit u, Collection<TokenBucket> tB, String d) {
        this.deviceId = dId;
        this.applicationId = aId;
        this.policerId = pId;
        this.colorAware = cA;
        this.unit = u;
        this.tokenBuckets = tB;
        this.description = d;
    }

    @Override
    public DeviceId deviceId() {
        return this.deviceId;
    }

    @Override
    public ApplicationId applicationId() {
        return this.applicationId;
    }

    @Override
    public PolicerId policerId() {
        return this.policerId;
    }

    @Override
    public boolean isColorAware() {
        return this.colorAware;
    }

    @Override
    public Policer.Unit unit() {
        return this.unit;
    }

    @Override
    public Collection<TokenBucket> tokenBuckets() {
        return this.tokenBuckets;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public long referenceCount() {
        return this.referenceCount;
    }

    @Override
    public void setReferenceCount(long count) {
        this.referenceCount = count;
    }

    @Override
    public long processedPackets() {
        return this.processedPackets;
    }

    @Override
    public void setProcessedPackets(long packets) {
        this.processedPackets = packets;
    }

    @Override
    public long processedBytes() {
        return this.processedBytes;
    }

    @Override
    public void setProcessedBytes(long bytes) {
        this.processedBytes = bytes;
    }

    @Override
    public long life() {
        return this.life;
    }

    @Override
    public void setLife(long l) {
        this.life = l;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("appId", (Object)this.applicationId()).add("id", (Object)this.policerId()).add("isColorAware", this.isColorAware()).add("unit", (Object)this.unit()).add("tokenBuckets", this.tokenBuckets()).add("description", (Object)this.description()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultPolicer that = (DefaultPolicer)o;
        return Objects.equal((Object)((Object)this.policerId), (Object)((Object)that.policerId));
    }

    public int hashCode() {
        return this.policerId.hashCode();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements Policer.Builder {
        private DeviceId deviceId;
        private ApplicationId applicationId;
        private PolicerId policerId;
        private boolean colorAware = false;
        private Policer.Unit unit = Policer.Unit.MB_PER_SEC;
        private Collection<TokenBucket> tokenBuckets;
        private String description = "";

        @Override
        public Policer.Builder forDeviceId(DeviceId dId) {
            this.deviceId = dId;
            return this;
        }

        @Override
        public Policer.Builder fromApp(ApplicationId appId) {
            this.applicationId = appId;
            return this;
        }

        @Override
        public Policer.Builder withId(PolicerId id) {
            this.policerId = id;
            return this;
        }

        @Override
        public Policer.Builder colorAware(boolean isColorAware) {
            this.colorAware = isColorAware;
            return this;
        }

        @Override
        public Policer.Builder withUnit(Policer.Unit u) {
            this.unit = u;
            return this;
        }

        @Override
        public Policer.Builder withPolicingResource(PolicingResource policingResource) {
            this.policerId = policingResource.policerId();
            this.deviceId = policingResource.connectPoint().deviceId();
            return this;
        }

        @Override
        public Policer.Builder withTokenBuckets(Collection<TokenBucket> tB) {
            this.tokenBuckets = ImmutableSet.copyOf(tB);
            return this;
        }

        @Override
        public Policer.Builder withDescription(String d) {
            this.description = d;
            return this;
        }

        @Override
        public DefaultPolicer build() {
            Preconditions.checkNotNull((Object)this.deviceId, (Object)"Must specify a deviceId");
            Preconditions.checkNotNull((Object)this.applicationId, (Object)"Must specify an application id");
            Preconditions.checkNotNull((Object)((Object)this.policerId), (Object)"Must specify a policer id");
            Preconditions.checkNotNull((Object)((Object)this.unit), (Object)"Must specify a unit for the policer");
            Preconditions.checkNotNull(this.tokenBuckets, (Object)"Must have token buckets");
            Preconditions.checkNotNull((Object)this.description, (Object)"Must have a description");
            Preconditions.checkArgument((!this.tokenBuckets.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one token bucket");
            return new DefaultPolicer(this.deviceId, this.applicationId, this.policerId, this.colorAware, this.unit, this.tokenBuckets, this.description);
        }
    }
}

