/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.trafficcontrol;

import com.google.common.annotations.Beta;
import java.util.Collection;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.trafficcontrol.PolicerId;
import org.onosproject.net.behaviour.trafficcontrol.PolicingResource;
import org.onosproject.net.behaviour.trafficcontrol.TokenBucket;

@Beta
public interface Policer {
    public DeviceId deviceId();

    public ApplicationId applicationId();

    public long referenceCount();

    public long processedPackets();

    public long processedBytes();

    public PolicerId policerId();

    public boolean isColorAware();

    public long life();

    public Unit unit();

    public Collection<TokenBucket> tokenBuckets();

    public String description();

    public static interface Builder {
        public Builder forDeviceId(DeviceId var1);

        public Builder fromApp(ApplicationId var1);

        public Builder withId(PolicerId var1);

        public Builder colorAware(boolean var1);

        public Builder withUnit(Unit var1);

        public Builder withPolicingResource(PolicingResource var1);

        public Builder withTokenBuckets(Collection<TokenBucket> var1);

        public Builder withDescription(String var1);

        public Policer build();
    }

    public static enum Unit {
        PKTS_PER_SEC,
        B_PER_SEC,
        KB_PER_SEC,
        MB_PER_SEC;

    }
}

