/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import org.onosproject.net.config.basics.AllowedEntityConfig;

public abstract class BasicElementConfig<S>
extends AllowedEntityConfig<S> {
    public static final String NAME = "name";
    public static final String UI_TYPE = "uiType";
    public static final String LOC_TYPE = "locType";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String GRID_Y = "gridY";
    public static final String GRID_X = "gridX";
    protected static final String RACK_ADDRESS = "rackAddress";
    protected static final String OWNER = "owner";
    protected static final String ROLES = "roles";
    protected static final double ZERO_THRESHOLD = 9.9E-324;
    private static final double DEFAULT_COORD = 0.0;
    public static final String LOC_TYPE_GEO = "geo";
    public static final String LOC_TYPE_GRID = "grid";
    public static final String LOC_TYPE_NONE = "none";
    private static final int NAME_MAX_LENGTH = 256;
    private static final int UI_TYPE_MAX_LENGTH = 128;
    private static final int LOC_TYPE_MAX_LENGTH = 32;
    private static final int RACK_ADDRESS_MAX_LENGTH = 256;
    private static final int OWNER_MAX_LENGTH = 128;

    public String name() {
        return this.get(NAME, this.subject.toString());
    }

    public BasicElementConfig name(String name) {
        return (BasicElementConfig)this.setOrClear(NAME, name);
    }

    public String uiType() {
        return this.get(UI_TYPE, null);
    }

    public BasicElementConfig uiType(String uiType) {
        return (BasicElementConfig)this.setOrClear(UI_TYPE, uiType);
    }

    public String locType() {
        String l = this.get(LATITUDE, null);
        String x = this.get(GRID_X, null);
        String def = l != null ? LOC_TYPE_GEO : (x != null ? LOC_TYPE_GRID : LOC_TYPE_NONE);
        return this.get(LOC_TYPE, def);
    }

    public BasicElementConfig locType(String locType) {
        String lt = Objects.equals(LOC_TYPE_GRID, locType) || Objects.equals(LOC_TYPE_GEO, locType) ? locType : LOC_TYPE_NONE;
        return (BasicElementConfig)this.setOrClear(LOC_TYPE, lt);
    }

    private boolean doubleIsZero(double value) {
        return value >= -9.9E-324 && value <= 9.9E-324;
    }

    public boolean geoCoordsSet() {
        return !this.doubleIsZero(this.latitude()) || !this.doubleIsZero(this.longitude());
    }

    public double latitude() {
        return this.get(LATITUDE, 0.0);
    }

    public BasicElementConfig latitude(Double latitude) {
        return (BasicElementConfig)this.setOrClear(LATITUDE, latitude);
    }

    public double longitude() {
        return this.get(LONGITUDE, 0.0);
    }

    public BasicElementConfig longitude(Double longitude) {
        return (BasicElementConfig)this.setOrClear(LONGITUDE, longitude);
    }

    public boolean gridCoordsSet() {
        return Objects.equals(this.locType(), LOC_TYPE_GRID);
    }

    public double gridY() {
        return this.get(GRID_Y, 0.0);
    }

    public BasicElementConfig gridY(Double y) {
        return (BasicElementConfig)this.setOrClear(GRID_Y, y);
    }

    public double gridX() {
        return this.get(GRID_X, 0.0);
    }

    public BasicElementConfig gridX(Double x) {
        return (BasicElementConfig)this.setOrClear(GRID_X, x);
    }

    public String rackAddress() {
        return this.get(RACK_ADDRESS, null);
    }

    public BasicElementConfig rackAddress(String address) {
        return (BasicElementConfig)this.setOrClear(RACK_ADDRESS, address);
    }

    public String owner() {
        return this.get(OWNER, null);
    }

    public BasicElementConfig owner(String owner) {
        return (BasicElementConfig)this.setOrClear(OWNER, owner);
    }

    public Set<String> roles() {
        ImmutableSet.Builder roles = ImmutableSet.builder();
        if (this.object.has(ROLES)) {
            ArrayNode roleNodes = (ArrayNode)this.object.path(ROLES);
            roleNodes.forEach(r -> roles.add((Object)r.asText()));
        }
        return roles.build();
    }

    public BasicElementConfig roles(Set<String> roles) {
        return (BasicElementConfig)this.setOrClear(ROLES, roles);
    }

    @Override
    public boolean isValid() {
        return this.isValidLength(NAME, 256) && this.isValidLength(UI_TYPE, 128) && this.isValidLength(LOC_TYPE, 32) && this.isValidLength(RACK_ADDRESS, 256) && this.isValidLength(OWNER, 128);
    }
}

