/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.host;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;

public class InterfaceIpAddress {
    private final IpAddress ipAddress;
    private final IpPrefix subnetAddress;
    private final IpAddress broadcastAddress;
    private final IpAddress peerAddress;

    public InterfaceIpAddress(InterfaceIpAddress other) {
        this.ipAddress = other.ipAddress;
        this.subnetAddress = other.subnetAddress;
        this.broadcastAddress = other.broadcastAddress;
        this.peerAddress = other.peerAddress;
    }

    public InterfaceIpAddress(IpAddress ipAddress, IpPrefix subnetAddress) {
        Preconditions.checkArgument((((IpAddress)Preconditions.checkNotNull((Object)ipAddress)).version() == ((IpPrefix)Preconditions.checkNotNull((Object)subnetAddress)).version() ? 1 : 0) != 0, (Object)"IP and subnet version mismatch");
        this.ipAddress = ipAddress;
        this.subnetAddress = subnetAddress;
        this.broadcastAddress = InterfaceIpAddress.computeBroadcastAddress(ipAddress, subnetAddress);
        this.peerAddress = null;
    }

    public InterfaceIpAddress(IpAddress ipAddress, IpPrefix subnetAddress, IpAddress broadcastAddress) {
        Preconditions.checkArgument((((IpAddress)Preconditions.checkNotNull((Object)ipAddress)).version() == ((IpPrefix)Preconditions.checkNotNull((Object)subnetAddress)).version() ? 1 : 0) != 0, (Object)"IP and subnet version mismatch");
        this.ipAddress = ipAddress;
        this.subnetAddress = subnetAddress;
        this.broadcastAddress = broadcastAddress;
        this.peerAddress = null;
    }

    public InterfaceIpAddress(IpAddress ipAddress, IpPrefix subnetAddress, IpAddress broadcastAddress, IpAddress peerAddress) {
        Preconditions.checkArgument((((IpAddress)Preconditions.checkNotNull((Object)ipAddress)).version() == ((IpPrefix)Preconditions.checkNotNull((Object)subnetAddress)).version() ? 1 : 0) != 0, (Object)"IP and subnet version mismatch");
        this.ipAddress = ipAddress;
        this.subnetAddress = subnetAddress;
        this.broadcastAddress = broadcastAddress;
        this.peerAddress = peerAddress;
    }

    public IpAddress ipAddress() {
        return this.ipAddress;
    }

    public IpPrefix subnetAddress() {
        return this.subnetAddress;
    }

    public IpAddress broadcastAddress() {
        return this.broadcastAddress;
    }

    public IpAddress peerAddress() {
        return this.peerAddress;
    }

    public static InterfaceIpAddress valueOf(String value) {
        String[] splits = value.split("/");
        Preconditions.checkArgument((splits.length == 2 ? 1 : 0) != 0, (Object)"Invalid IP address and prefix length format");
        IpPrefix subnet = IpPrefix.valueOf((String)value);
        IpAddress addr = IpAddress.valueOf((String)splits[0]);
        return new InterfaceIpAddress(addr, subnet);
    }

    public static IpAddress computeBroadcastAddress(IpAddress ipAddress, IpPrefix subnetAddress) {
        if (ipAddress.isIp6()) {
            return null;
        }
        IpAddress maskedIP = IpAddress.makeMaskedAddress((IpAddress)ipAddress, (int)subnetAddress.prefixLength());
        int ipB = maskedIP.getIp4Address().toInt() | (1 << 32 - subnetAddress.prefixLength()) - 1;
        return IpAddress.valueOf((int)ipB);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof InterfaceIpAddress)) {
            return false;
        }
        InterfaceIpAddress otherAddr = (InterfaceIpAddress)other;
        return Objects.equals(this.ipAddress, otherAddr.ipAddress) && Objects.equals(this.subnetAddress, otherAddr.subnetAddress) && Objects.equals(this.broadcastAddress, otherAddr.broadcastAddress) && Objects.equals(this.peerAddress, otherAddr.peerAddress);
    }

    public int hashCode() {
        return Objects.hash(this.ipAddress, this.subnetAddress, this.broadcastAddress, this.peerAddress);
    }

    public String toString() {
        return this.ipAddress.toString() + "/" + this.subnetAddress.prefixLength();
    }
}

