/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Optional;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.Path;
import org.onosproject.net.ResourceGroup;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.Key;

@Beta
public final class OpticalConnectivityIntent
extends Intent {
    private final ConnectPoint src;
    private final ConnectPoint dst;
    private final OduSignalType signalType;
    private final boolean isBidirectional;
    private final Optional<OchSignal> ochSignal;
    private final Optional<Path> suggestedPath;

    protected OpticalConnectivityIntent(ApplicationId appId, Key key, ConnectPoint src, ConnectPoint dst, OduSignalType signalType, boolean isBidirectional, Optional<OchSignal> ochSignal, Optional<Path> suggestedPath, int priority, ResourceGroup resourceGroup) {
        super(appId, key, Collections.emptyList(), priority, resourceGroup);
        this.src = (ConnectPoint)Preconditions.checkNotNull((Object)src);
        this.dst = (ConnectPoint)Preconditions.checkNotNull((Object)dst);
        this.signalType = (OduSignalType)((Object)Preconditions.checkNotNull((Object)((Object)signalType)));
        this.isBidirectional = isBidirectional;
        this.ochSignal = ochSignal;
        this.suggestedPath = suggestedPath;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected OpticalConnectivityIntent() {
        this.src = null;
        this.dst = null;
        this.signalType = null;
        this.isBidirectional = false;
        this.ochSignal = null;
        this.suggestedPath = null;
    }

    public ConnectPoint getSrc() {
        return this.src;
    }

    public ConnectPoint getDst() {
        return this.dst;
    }

    public OduSignalType getSignalType() {
        return this.signalType;
    }

    public boolean isBidirectional() {
        return this.isBidirectional;
    }

    public Optional<OchSignal> ochSignal() {
        return this.ochSignal;
    }

    public Optional<Path> suggestedPath() {
        return this.suggestedPath;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id()).add("key", (Object)this.key()).add("appId", (Object)this.appId()).add("priority", this.priority()).add("resources", this.resources()).add("src", (Object)this.src).add("dst", (Object)this.dst).add("signalType", (Object)this.signalType).add("isBidirectional", this.isBidirectional).add("ochSignal", this.ochSignal).add("suggestedPath", this.suggestedPath).add("resourceGroup", (Object)this.resourceGroup()).toString();
    }

    public static class Builder
    extends Intent.Builder {
        private ConnectPoint src;
        private ConnectPoint dst;
        private OduSignalType signalType;
        private boolean isBidirectional;
        private Optional<OchSignal> ochSignal = Optional.empty();
        private Optional<Path> suggestedPath = Optional.empty();

        @Override
        public Builder appId(ApplicationId appId) {
            return (Builder)super.appId(appId);
        }

        @Override
        public Builder key(Key key) {
            return (Builder)super.key(key);
        }

        @Override
        public Builder priority(int priority) {
            return (Builder)super.priority(priority);
        }

        @Override
        public Builder resourceGroup(ResourceGroup resourceGroup) {
            return (Builder)super.resourceGroup(resourceGroup);
        }

        public Builder src(ConnectPoint src) {
            this.src = src;
            return this;
        }

        public Builder dst(ConnectPoint dst) {
            this.dst = dst;
            return this;
        }

        public Builder signalType(OduSignalType signalType) {
            this.signalType = signalType;
            return this;
        }

        public Builder bidirectional(boolean isBidirectional) {
            this.isBidirectional = isBidirectional;
            return this;
        }

        public Builder ochSignal(OchSignal ochSignal) {
            this.ochSignal = Optional.ofNullable(ochSignal);
            return this;
        }

        public Builder suggestedPath(Path suggestedPath) {
            this.suggestedPath = Optional.ofNullable(suggestedPath);
            return this;
        }

        public OpticalConnectivityIntent build() {
            return new OpticalConnectivityIntent(this.appId, this.key, this.src, this.dst, this.signalType, this.isBidirectional, this.ochSignal, this.suggestedPath, this.priority, this.resourceGroup);
        }
    }
}

