/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onosproject.net.DeviceId;
import org.onosproject.net.pi.runtime.PiCounterCell;
import org.onosproject.net.pi.runtime.PiCounterCellId;
import org.onosproject.net.pi.runtime.PiEntityType;
import org.onosproject.net.pi.runtime.PiHandle;

public final class PiCounterCellHandle
extends PiHandle {
    private final PiCounterCellId cellId;

    private PiCounterCellHandle(DeviceId deviceId, PiCounterCellId cellId) {
        super(deviceId);
        this.cellId = (PiCounterCellId)Preconditions.checkNotNull((Object)cellId);
    }

    public static PiCounterCellHandle of(DeviceId deviceId, PiCounterCellId cellId) {
        return new PiCounterCellHandle(deviceId, cellId);
    }

    public static PiCounterCellHandle of(DeviceId deviceId, PiCounterCell cell) {
        return new PiCounterCellHandle(deviceId, cell.cellId());
    }

    public PiCounterCellId cellId() {
        return this.cellId;
    }

    @Override
    public PiEntityType entityType() {
        return PiEntityType.COUNTER_CELL;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.deviceId(), this.cellId});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PiCounterCellHandle other = (PiCounterCellHandle)obj;
        return Objects.equal((Object)this.deviceId(), (Object)other.deviceId()) && Objects.equal((Object)this.cellId, (Object)other.cellId);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("deviceId", (Object)this.deviceId()).add("cellId", (Object)this.cellId).toString();
    }
}

