/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime.data;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onosproject.net.pi.model.PiData;
import org.onosproject.net.pi.runtime.data.PiHeader;

@Beta
public final class PiHeaderUnion
implements PiData {
    private final String validHeaderName;
    private final PiHeader header;
    private final boolean isValid;

    private PiHeaderUnion(boolean isValid, String validHeaderName, PiHeader header) {
        this.isValid = isValid;
        this.validHeaderName = validHeaderName;
        this.header = header;
    }

    public static PiHeaderUnion ofInvalid() {
        return new PiHeaderUnion(false, null, null);
    }

    public static PiHeaderUnion of(String validHeaderName, PiHeader header) {
        Preconditions.checkNotNull((Object)validHeaderName);
        Preconditions.checkArgument((!validHeaderName.isEmpty() ? 1 : 0) != 0, (Object)"The header name must not be empty");
        Preconditions.checkNotNull((Object)header);
        return new PiHeaderUnion(true, validHeaderName, header);
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String headerName() {
        return this.validHeaderName;
    }

    public PiHeader header() {
        return this.header;
    }

    @Override
    public PiData.Type type() {
        return PiData.Type.HEADERUNION;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiHeaderUnion headerUnion = (PiHeaderUnion)o;
        return Objects.equal((Object)this.validHeaderName, (Object)headerUnion.validHeaderName) && Objects.equal((Object)this.header, (Object)headerUnion.header);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.validHeaderName, this.header});
    }

    public String toString() {
        return !this.isValid ? "INVALID" : this.validHeaderName + ":" + this.header.toString();
    }
}

