/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.SetEventListener;
import org.onosproject.store.service.StorageException;
import org.onosproject.store.service.Synchronous;

public class DefaultDistributedSet<E>
extends Synchronous<AsyncDistributedSet<E>>
implements DistributedSet<E> {
    private final long operationTimeoutMillis;
    private final AsyncDistributedSet<E> asyncSet;

    public DefaultDistributedSet(AsyncDistributedSet<E> asyncSet, long operationTimeoutMillis) {
        super(asyncSet);
        this.asyncSet = asyncSet;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public int size() {
        return this.complete(this.asyncSet.size());
    }

    @Override
    public boolean isEmpty() {
        return this.complete(this.asyncSet.isEmpty());
    }

    @Override
    public boolean contains(Object o) {
        return this.complete(this.asyncSet.contains(o));
    }

    @Override
    public Iterator<E> iterator() {
        return this.complete(this.asyncSet.getAsImmutableSet()).iterator();
    }

    @Override
    public Object[] toArray() {
        return this.complete(this.asyncSet.getAsImmutableSet()).stream().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] resizedArray = (Object[])Array.newInstance(a.getClass().getComponentType(), this.complete(this.asyncSet.getAsImmutableSet()).size());
        return this.complete(this.asyncSet.getAsImmutableSet()).toArray(resizedArray);
    }

    @Override
    public boolean add(E e) {
        return this.complete(this.asyncSet.add(e));
    }

    @Override
    public boolean remove(Object o) {
        return this.complete(this.asyncSet.remove(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.complete(this.asyncSet.containsAll(c));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.complete(this.asyncSet.addAll(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.complete(this.asyncSet.retainAll(c));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.complete(this.asyncSet.removeAll(c));
    }

    @Override
    public void clear() {
        this.complete(this.asyncSet.clear());
    }

    @Override
    public void addListener(SetEventListener<E> listener) {
        this.complete(this.asyncSet.addListener(listener));
    }

    @Override
    public void removeListener(SetEventListener<E> listener) {
        this.complete(this.asyncSet.removeListener(listener));
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new StorageException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new StorageException.Timeout();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof StorageException) {
                throw (StorageException)e.getCause();
            }
            throw new StorageException(e.getCause());
        }
    }
}

