/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import org.onlab.util.Bandwidth;
import org.onosproject.net.AbstractDescription;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.behaviour.QueueDescription;
import org.onosproject.net.behaviour.QueueId;

@Beta
public final class DefaultQueueDescription
extends AbstractDescription
implements QueueDescription {
    private final QueueId queueId;
    private final Optional<Integer> dscp;
    private final EnumSet<QueueDescription.Type> type;
    private final Optional<Bandwidth> maxRate;
    private final Optional<Bandwidth> minRate;
    private final Optional<Long> burst;
    private final Optional<Long> priority;
    public static final int MIN_DSCP = 0;
    public static final int MAX_DSCP = 63;

    private DefaultQueueDescription(QueueId queueId, Optional<Integer> dscp, EnumSet<QueueDescription.Type> type, Optional<Bandwidth> maxRate, Optional<Bandwidth> minRate, Optional<Long> burst, Optional<Long> priority, SparseAnnotations ... annotations) {
        super(annotations);
        dscp.ifPresent(dscpValue -> Preconditions.checkArgument((dscpValue >= 0 && dscpValue <= 63 ? 1 : 0) != 0, (Object)"dscp should be in range 0 to 63."));
        this.queueId = (QueueId)Preconditions.checkNotNull((Object)queueId);
        this.dscp = dscp;
        this.type = type;
        this.maxRate = maxRate;
        this.minRate = minRate;
        this.burst = burst;
        this.priority = priority;
    }

    @Override
    public QueueId queueId() {
        return this.queueId;
    }

    @Override
    public EnumSet<QueueDescription.Type> type() {
        return this.type;
    }

    @Override
    public Optional<Integer> dscp() {
        return this.dscp;
    }

    @Override
    public Optional<Bandwidth> maxRate() {
        return this.maxRate;
    }

    @Override
    public Optional<Bandwidth> minRate() {
        return this.minRate;
    }

    @Override
    public Optional<Long> burst() {
        return this.burst;
    }

    @Override
    public Optional<Long> priority() {
        return this.priority;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.queueId, this.type, this.dscp, this.maxRate, this.minRate, this.burst, this.priority);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultQueueDescription) {
            DefaultQueueDescription other = (DefaultQueueDescription)obj;
            return Objects.equals(this.queueId, other.queueId) && Objects.equals(this.type, other.type) && Objects.equals(this.dscp, other.dscp) && Objects.equals(this.maxRate, other.maxRate) && Objects.equals(this.minRate, other.minRate) && Objects.equals(this.burst, other.burst) && Objects.equals(this.priority, other.priority);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.queueId()).add("type", this.type()).add("dscp", (Object)this.dscp().orElse(0)).add("maxRate", this.maxRate().orElse(null)).add("minRate", this.minRate().orElse(null)).add("burst", (Object)this.burst().orElse(0L)).add("priority", (Object)this.priority().orElse(0L)).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements QueueDescription.Builder {
        private QueueId queueId;
        private Optional<Integer> dscp = Optional.empty();
        private EnumSet<QueueDescription.Type> type;
        private Optional<Bandwidth> minRate = Optional.empty();
        private Optional<Bandwidth> maxRate = Optional.empty();
        private Optional<Long> burst = Optional.empty();
        private Optional<Long> priority = Optional.empty();

        private Builder() {
        }

        @Override
        public QueueDescription build() {
            return new DefaultQueueDescription(this.queueId, this.dscp, this.type, this.maxRate, this.minRate, this.burst, this.priority, new SparseAnnotations[0]);
        }

        @Override
        public Builder queueId(QueueId queueId) {
            this.queueId = queueId;
            return this;
        }

        @Override
        public Builder dscp(Integer dscp) {
            this.dscp = Optional.ofNullable(dscp);
            return this;
        }

        @Override
        public Builder type(EnumSet<QueueDescription.Type> type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder maxRate(Bandwidth maxRate) {
            this.maxRate = Optional.ofNullable(maxRate);
            return this;
        }

        @Override
        public Builder minRate(Bandwidth minRate) {
            this.minRate = Optional.ofNullable(minRate);
            return this;
        }

        @Override
        public Builder burst(Long burst) {
            this.burst = Optional.ofNullable(burst);
            return this;
        }

        @Override
        public Builder priority(Long priority) {
            this.priority = Optional.ofNullable(priority);
            return this;
        }
    }
}

