/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import java.util.Objects;
import org.onosproject.net.flow.criteria.Criterion;

public final class PbbIsidCriterion
implements Criterion {
    private static final int MASK = 1048575;
    private final int pbbIsid;

    PbbIsidCriterion(int pbbIsid) {
        this.pbbIsid = pbbIsid & 0xFFFFF;
    }

    @Override
    public Criterion.Type type() {
        return Criterion.Type.PBB_ISID;
    }

    public int pbbIsid() {
        return this.pbbIsid;
    }

    public String toString() {
        return this.type().toString() + ":" + Long.toHexString(this.pbbIsid);
    }

    public int hashCode() {
        return Objects.hash(this.type().ordinal(), this.pbbIsid);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PbbIsidCriterion) {
            PbbIsidCriterion that = (PbbIsidCriterion)obj;
            return Objects.equals(this.pbbIsid, that.pbbIsid) && Objects.equals((Object)this.type(), (Object)that.type());
        }
        return false;
    }
}

