/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.model.topo;

import org.onosproject.net.region.RegionId;
import org.onosproject.ui.model.topo.UiLink;
import org.onosproject.ui.model.topo.UiLinkId;
import org.onosproject.ui.model.topo.UiTopology;

public class UiRegionLink
extends UiLink {
    private static final String E_NOT_REGION_ID = "UI link identifier not region to region";
    private final RegionId regionA;
    private final RegionId regionB;

    public UiRegionLink(UiTopology topology, UiLinkId id) {
        super(topology, id);
        this.regionA = id.regionA();
        this.regionB = id.regionB();
        if (this.regionA == null || this.regionB == null) {
            throw new IllegalArgumentException(E_NOT_REGION_ID);
        }
    }

    @Override
    public String endPointA() {
        return (String)this.regionA.id();
    }

    @Override
    public String endPointB() {
        return (String)this.regionB.id();
    }

    public RegionId regionA() {
        return this.regionA;
    }

    public RegionId regionB() {
        return this.regionB;
    }
}

