/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.instructions;

import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onosproject.net.flow.instructions.Instruction;

public abstract class L3ModificationInstruction
implements Instruction {
    private static final String SEPARATOR = ":";

    public abstract L3SubType subtype();

    @Override
    public final Instruction.Type type() {
        return Instruction.Type.L3MODIFICATION;
    }

    public static final class ModDscpInstruction
    extends L3ModificationInstruction {
        private final L3SubType subtype;
        private final byte dscp;

        ModDscpInstruction(L3SubType subtype, byte dscp) {
            this.subtype = subtype;
            this.dscp = dscp;
        }

        @Override
        public L3SubType subtype() {
            return this.subtype;
        }

        public String toString() {
            return this.subtype().toString() + L3ModificationInstruction.SEPARATOR + this.dscp();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.dscp()});
        }

        public byte dscp() {
            return this.dscp;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModDscpInstruction) {
                ModDscpInstruction that = (ModDscpInstruction)obj;
                return Objects.equals((Object)this.subtype(), (Object)that.subtype()) && Objects.equals(this.dscp(), that.dscp());
            }
            return false;
        }
    }

    public static final class ModTtlInstruction
    extends L3ModificationInstruction {
        private final L3SubType subtype;

        ModTtlInstruction(L3SubType subtype) {
            this.subtype = subtype;
        }

        @Override
        public L3SubType subtype() {
            return this.subtype;
        }

        public String toString() {
            return this.subtype().toString();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype()});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModTtlInstruction) {
                ModTtlInstruction that = (ModTtlInstruction)obj;
                return Objects.equals((Object)this.subtype(), (Object)that.subtype());
            }
            return false;
        }
    }

    public static final class ModIPv6FlowLabelInstruction
    extends L3ModificationInstruction {
        private static final int MASK = 1048575;
        private final int flowLabel;

        ModIPv6FlowLabelInstruction(int flowLabel) {
            this.flowLabel = flowLabel & 0xFFFFF;
        }

        @Override
        public L3SubType subtype() {
            return L3SubType.IPV6_FLABEL;
        }

        public int flowLabel() {
            return this.flowLabel;
        }

        public String toString() {
            return this.subtype().toString() + L3ModificationInstruction.SEPARATOR + Long.toHexString(this.flowLabel);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.flowLabel});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModIPv6FlowLabelInstruction) {
                ModIPv6FlowLabelInstruction that = (ModIPv6FlowLabelInstruction)obj;
                return Objects.equals(this.flowLabel, that.flowLabel);
            }
            return false;
        }
    }

    public static final class ModArpOpInstruction
    extends L3ModificationInstruction {
        private final L3SubType subtype;
        private final short op;

        ModArpOpInstruction(L3SubType subType, short op) {
            this.subtype = subType;
            this.op = op;
        }

        @Override
        public L3SubType subtype() {
            return this.subtype;
        }

        public long op() {
            return this.op;
        }

        public String toString() {
            return this.subtype().toString() + L3ModificationInstruction.SEPARATOR + this.op;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.op});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModArpOpInstruction) {
                ModArpOpInstruction that = (ModArpOpInstruction)obj;
                return Objects.equals(this.op, that.op) && Objects.equals((Object)this.subtype(), (Object)that.subtype());
            }
            return false;
        }
    }

    public static final class ModArpEthInstruction
    extends L3ModificationInstruction {
        private final L3SubType subtype;
        private final MacAddress mac;

        ModArpEthInstruction(L3SubType subType, MacAddress addr) {
            this.subtype = subType;
            this.mac = addr;
        }

        @Override
        public L3SubType subtype() {
            return this.subtype;
        }

        public MacAddress mac() {
            return this.mac;
        }

        public String toString() {
            return this.subtype().toString() + L3ModificationInstruction.SEPARATOR + this.mac;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.mac});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModArpEthInstruction) {
                ModArpEthInstruction that = (ModArpEthInstruction)obj;
                return Objects.equals(this.mac, that.mac) && Objects.equals((Object)this.subtype(), (Object)that.subtype());
            }
            return false;
        }
    }

    public static final class ModArpIPInstruction
    extends L3ModificationInstruction {
        private final L3SubType subtype;
        private final IpAddress ip;

        ModArpIPInstruction(L3SubType subType, IpAddress addr) {
            this.subtype = subType;
            this.ip = addr;
        }

        @Override
        public L3SubType subtype() {
            return this.subtype;
        }

        public IpAddress ip() {
            return this.ip;
        }

        public String toString() {
            return this.subtype().toString() + L3ModificationInstruction.SEPARATOR + this.ip;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.ip});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModArpIPInstruction) {
                ModArpIPInstruction that = (ModArpIPInstruction)obj;
                return Objects.equals(this.ip, that.ip) && Objects.equals((Object)this.subtype(), (Object)that.subtype());
            }
            return false;
        }
    }

    public static final class ModIPInstruction
    extends L3ModificationInstruction {
        private final L3SubType subtype;
        private final IpAddress ip;

        ModIPInstruction(L3SubType subType, IpAddress addr) {
            this.subtype = subType;
            this.ip = addr;
        }

        @Override
        public L3SubType subtype() {
            return this.subtype;
        }

        public IpAddress ip() {
            return this.ip;
        }

        public String toString() {
            return this.subtype().toString() + L3ModificationInstruction.SEPARATOR + this.ip;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type(), this.subtype(), this.ip});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ModIPInstruction) {
                ModIPInstruction that = (ModIPInstruction)obj;
                return Objects.equals(this.ip, that.ip) && Objects.equals((Object)this.subtype(), (Object)that.subtype());
            }
            return false;
        }
    }

    public static enum L3SubType {
        IPV4_SRC,
        IPV4_DST,
        IPV6_SRC,
        IPV6_DST,
        IPV6_FLABEL,
        DEC_TTL,
        TTL_OUT,
        TTL_IN,
        ARP_SPA,
        ARP_SHA,
        ARP_OP,
        IP_DSCP;

    }
}

