/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.collect.ImmutableList;
import com.google.common.testing.EqualsTester;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.PortNumber;

public class PortNumberTest {
    @Test
    public void basics() {
        new EqualsTester().addEqualityGroup(new Object[]{PortNumber.portNumber((long)123L), PortNumber.portNumber((String)"123")}).addEqualityGroup(new Object[]{PortNumber.portNumber((long)321L), PortNumber.portNumber((long)321L, (String)"LIM-3-2-1")}).testEquals();
    }

    @Test
    public void number() {
        Assert.assertEquals((String)"incorrect long value", (long)12345L, (long)PortNumber.portNumber((long)12345L).toLong());
    }

    @Test
    public void decimalPortNumberIsReconstructableFromString() {
        ImmutableList ps = ImmutableList.builder().add((Object)PortNumber.portNumber((long)0L)).add((Object)PortNumber.portNumber((long)1L)).add((Object)PortNumber.portNumber((long)6653L)).add((Object)PortNumber.portNumber((long)0xFFFFFFFFL)).build();
        ps.forEach(p -> Assert.assertEquals((Object)p, (Object)PortNumber.fromString((String)p.toString())));
    }

    @Test
    public void logicalPortNumberIsReconstructableFromString() {
        List<PortNumber> ps = ImmutableList.copyOf((Object[])PortNumber.Logical.values()).stream().map(PortNumber.Logical::instance).collect(Collectors.toList());
        ps.forEach(p -> Assert.assertEquals((Object)p, (Object)PortNumber.fromString((String)p.toString())));
        PortNumber unknown = PortNumber.portNumber((long)-42L);
        Assert.assertEquals((Object)unknown, (Object)PortNumber.fromString((String)unknown.toString()));
    }

    @Test
    public void namedPortNumberIsReconstructableFromString() {
        ImmutableList ps = ImmutableList.builder().add((Object)PortNumber.portNumber((long)0L, (String)"Zero")).add((Object)PortNumber.portNumber((long)1L, (String)"[ONE]")).add((Object)PortNumber.portNumber((long)6653L, (String)"OpenFlow (1.3+)")).add((Object)PortNumber.portNumber((long)0xFFFFFFFFL, (String)"(\u5927)")).build();
        ps.forEach(p -> Assert.assertEquals((Object)p, (Object)PortNumber.fromString((String)p.toString())));
    }

    @Test
    public void exactlyEquals() {
        Assert.assertTrue((boolean)PortNumber.portNumber((long)0L).exactlyEquals(PortNumber.portNumber((long)0L)));
        Assert.assertTrue((boolean)PortNumber.portNumber((long)0L, (String)"foo").exactlyEquals(PortNumber.portNumber((long)0L, (String)"foo")));
        Assert.assertFalse((boolean)PortNumber.portNumber((long)0L, (String)"foo").exactlyEquals(PortNumber.portNumber((long)0L, (String)"bar")));
        Assert.assertFalse((boolean)PortNumber.portNumber((long)0L, (String)"foo").exactlyEquals(PortNumber.portNumber((long)0L)));
        Assert.assertFalse((boolean)PortNumber.portNumber((long)0L, (String)"foo").exactlyEquals(PortNumber.portNumber((long)1L, (String)"foo")));
        Assert.assertFalse((boolean)PortNumber.portNumber((long)123L).exactlyEquals(PortNumber.portNumber((long)123L, (String)"123")));
    }
}

