/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.config.ConfigApplyDelegate;
import org.onosproject.net.config.basics.AbstractConfigTest;
import org.onosproject.net.config.basics.InterfaceConfig;
import org.onosproject.net.host.InterfaceIpAddress;
import org.onosproject.net.intf.Interface;

public class InterfaceConfigTest
extends AbstractConfigTest {
    private JsonNode data;
    private ConnectPoint cp1 = NetTestTools.connectPoint("device1", 1);
    private ConfigApplyDelegate delegate = configApply -> {};
    private VlanId vl1 = VlanId.vlanId((short)1);
    private String name1 = this.getName(1);
    private String name2 = this.getName(2);
    private String name3 = this.getName(3);
    private String name4 = this.getName(4);

    @Before
    public void setUp() {
        this.data = this.getTestJson("interface-config-1.json");
    }

    private String getName(int index) {
        String nameTemplate = "interface";
        return nameTemplate + Integer.toString(index);
    }

    private MacAddress getMac(int index) {
        String macTemplate = "AB:CD:EF:00:00:0";
        return MacAddress.valueOf((String)(macTemplate + Integer.toString(index)));
    }

    private InterfaceIpAddress getIp(int index, int position) {
        IpPrefix subnet1 = IpPrefix.valueOf((String)"1.2.0.0/16");
        IpAddress ip = IpAddress.valueOf((String)("1.2.3." + Integer.toString(index + (position - 1) * 10)));
        return new InterfaceIpAddress(ip, subnet1);
    }

    private Interface findInterface(Collection<Interface> ifs, String name) {
        return ifs.stream().filter(iface -> iface.name().equals(name)).findFirst().orElse(null);
    }

    private void checkInterface(Interface fetchedInterface, int index) {
        String name = this.getName(index);
        MatcherAssert.assertThat((Object)fetchedInterface, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)fetchedInterface.name(), (Matcher)Matchers.is((Object)name));
        MatcherAssert.assertThat((Object)fetchedInterface.connectPoint(), (Matcher)Matchers.is((Object)this.cp1));
        MatcherAssert.assertThat((Object)fetchedInterface.mac(), (Matcher)Matchers.is((Object)this.getMac(index)));
        List fetchedIpAddresses = fetchedInterface.ipAddressesList();
        MatcherAssert.assertThat((Object)fetchedIpAddresses, (Matcher)Matchers.hasItems((Object[])new InterfaceIpAddress[]{this.getIp(index, 1), this.getIp(index, 2)}));
    }

    @Test
    public void testConstruction() throws Exception {
        InterfaceConfig config = new InterfaceConfig();
        config.init((Object)this.cp1, "KEY", this.data, this.mapper, this.delegate);
        MatcherAssert.assertThat((Object)config.isValid(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)config.getInterfaces(), (Matcher)Matchers.hasSize((int)4));
        Interface fetchedInterface1 = this.findInterface(config.getInterfaces(), this.name1);
        this.checkInterface(fetchedInterface1, 1);
        MatcherAssert.assertThat((Object)fetchedInterface1.vlan(), (Matcher)Matchers.is((Object)this.vl1));
        Interface fetchedInterface2 = this.findInterface(config.getInterfaces(), this.name2);
        this.checkInterface(fetchedInterface2, 2);
        MatcherAssert.assertThat((Object)fetchedInterface2.vlanUntagged().toShort(), (Matcher)Matchers.is((Object)22));
        MatcherAssert.assertThat((Object)fetchedInterface2.vlan().toShort(), (Matcher)Matchers.is((Object)2));
        Interface fetchedInterface3 = this.findInterface(config.getInterfaces(), this.name3);
        this.checkInterface(fetchedInterface3, 3);
        MatcherAssert.assertThat((Object)fetchedInterface3.vlanTagged(), (Matcher)Matchers.is((Matcher)Matchers.allOf((Matcher)Matchers.notNullValue(), (Matcher)Matchers.hasSize((int)1))));
        MatcherAssert.assertThat((Object)fetchedInterface3.vlan().toShort(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((Object)fetchedInterface3.vlanTagged(), (Matcher)Matchers.contains((Object[])new VlanId[]{VlanId.vlanId((short)33)}));
        Interface fetchedInterface4 = this.findInterface(config.getInterfaces(), this.name4);
        this.checkInterface(fetchedInterface4, 4);
        MatcherAssert.assertThat((Object)fetchedInterface4.vlanTagged(), (Matcher)Matchers.is((Matcher)Matchers.allOf((Matcher)Matchers.notNullValue(), (Matcher)Matchers.hasSize((int)1))));
        MatcherAssert.assertThat((Object)fetchedInterface4.vlanTagged(), (Matcher)Matchers.contains((Object[])new VlanId[]{VlanId.vlanId((short)44)}));
        MatcherAssert.assertThat((Object)fetchedInterface4.vlanNative().toShort(), (Matcher)Matchers.is((Object)4));
    }

    @Test
    public void testAddRemoveInterface() throws Exception {
        InterfaceConfig config = new InterfaceConfig();
        config.init((Object)this.cp1, "KEY", this.data, this.mapper, this.delegate);
        ImmutableSet vlanTagged = ImmutableSet.of((Object)VlanId.vlanId((short)33), (Object)VlanId.vlanId((short)44));
        String newName = "interface5";
        Interface toAdd1 = new Interface(newName, this.cp1, (List)ImmutableList.of((Object)this.getIp(5, 1), (Object)this.getIp(5, 2)), this.getMac(5), this.vl1, null, (Set)vlanTagged, this.vl1);
        config.addInterface(toAdd1);
        MatcherAssert.assertThat((Object)config.isValid(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)config.getInterfaces(), (Matcher)Matchers.allOf((Matcher)Matchers.notNullValue(), (Matcher)Matchers.hasSize((int)5)));
        MatcherAssert.assertThat((Object)this.findInterface(config.getInterfaces(), this.name1), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.findInterface(config.getInterfaces(), this.name2), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.findInterface(config.getInterfaces(), this.name3), (Matcher)Matchers.notNullValue());
        Interface addedInterface1 = this.findInterface(config.getInterfaces(), newName);
        this.checkInterface(addedInterface1, 5);
        MatcherAssert.assertThat((Object)addedInterface1.vlan(), (Matcher)Matchers.is((Object)this.vl1));
        MatcherAssert.assertThat((Object)addedInterface1.vlanTagged(), (Matcher)Matchers.allOf((Matcher)Matchers.notNullValue(), (Matcher)Matchers.hasSize((int)2)));
        config.removeInterface(newName);
        MatcherAssert.assertThat((Object)config.getInterfaces(), (Matcher)Matchers.allOf((Matcher)Matchers.notNullValue(), (Matcher)Matchers.hasSize((int)4)));
        MatcherAssert.assertThat((Object)this.findInterface(config.getInterfaces(), newName), (Matcher)Matchers.nullValue());
        newName = this.getName(6);
        Interface toAdd2 = new Interface(newName, this.cp1, (List)ImmutableList.of((Object)this.getIp(6, 1), (Object)this.getIp(6, 2)), this.getMac(6), this.vl1, VlanId.vlanId((short)77), null, this.vl1);
        config.addInterface(toAdd2);
        Interface addedInterface2 = this.findInterface(config.getInterfaces(), newName);
        this.checkInterface(addedInterface2, 6);
        MatcherAssert.assertThat((Object)addedInterface2.vlan(), (Matcher)Matchers.is((Object)this.vl1));
        MatcherAssert.assertThat((Object)addedInterface2.vlanUntagged().toShort(), (Matcher)Matchers.is((Object)77));
    }
}

