/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsEqual;
import org.junit.Before;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.AbstractIntentTest;
import org.onosproject.net.intent.IntentTestsMocks;
import org.onosproject.net.intent.TwoWayP2PIntent;

public class TwoWayP2PIntentTest
extends AbstractIntentTest {
    TrafficSelector selector;
    TrafficTreatment treatment;
    TwoWayP2PIntent intent1;
    TwoWayP2PIntent intent2;
    static final int PRIORITY = 12;

    @Before
    public void twoWatP2PIntentTestSetUp() {
        this.selector = new IntentTestsMocks.MockSelector();
        this.treatment = new IntentTestsMocks.MockTreatment();
        this.intent1 = TwoWayP2PIntent.builder().appId(NetTestTools.APP_ID).priority(12).selector(this.selector).treatment(this.treatment).one(NetTestTools.connectPoint("one", 1)).two(NetTestTools.connectPoint("two", 2)).build();
        this.intent2 = TwoWayP2PIntent.builder().appId(NetTestTools.APP_ID).priority(12).selector(this.selector).treatment(this.treatment).one(NetTestTools.connectPoint("two", 2)).two(NetTestTools.connectPoint("three", 2)).build();
    }

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(TwoWayP2PIntent.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.intent1}).addEqualityGroup(new Object[]{this.intent2}).testEquals();
    }

    @Test
    public void testContents() {
        MatcherAssert.assertThat((Object)this.intent1.appId(), (Matcher)IsEqual.equalTo((Object)NetTestTools.APP_ID));
        MatcherAssert.assertThat((Object)this.intent1.one(), (Matcher)Matchers.equalTo((Object)NetTestTools.connectPoint("one", 1)));
        MatcherAssert.assertThat((Object)this.intent1.two(), (Matcher)Matchers.equalTo((Object)NetTestTools.connectPoint("two", 2)));
        MatcherAssert.assertThat((Object)this.intent1.priority(), (Matcher)Matchers.is((Object)12));
        MatcherAssert.assertThat((Object)this.intent1.selector(), (Matcher)Matchers.is((Object)this.selector));
        MatcherAssert.assertThat((Object)this.intent1.treatment(), (Matcher)Matchers.is((Object)this.treatment));
    }
}

