/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.link;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.LinkKey;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkProvider;
import org.onosproject.net.link.LinkProviderService;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;

public class LinkProviderServiceAdapter
extends AbstractProviderService<LinkProvider>
implements LinkProviderService {
    List<DeviceId> vanishedDpid = Lists.newLinkedList();
    List<Long> vanishedPort = Lists.newLinkedList();
    Map<DeviceId, DeviceId> discoveredLinks = Maps.newHashMap();
    Map<LinkKey, LinkDescription> discoveredLinkDescriptions = new HashMap<LinkKey, LinkDescription>();

    protected LinkProviderServiceAdapter(LinkProvider provider) {
        super((Provider)provider);
    }

    public void linkDetected(LinkDescription linkDescription) {
        LinkKey key = LinkKey.linkKey((ConnectPoint)linkDescription.src(), (ConnectPoint)linkDescription.dst());
        this.discoveredLinkDescriptions.put(key, linkDescription);
        DeviceId sDid = linkDescription.src().deviceId();
        DeviceId dDid = linkDescription.dst().deviceId();
        this.discoveredLinks.put(sDid, dDid);
    }

    public void linkVanished(LinkDescription linkDescription) {
        LinkKey key = LinkKey.linkKey((ConnectPoint)linkDescription.src(), (ConnectPoint)linkDescription.dst());
        this.discoveredLinkDescriptions.remove(key);
    }

    public void linksVanished(ConnectPoint connectPoint) {
        this.vanishedPort.add(connectPoint.port().toLong());
    }

    public void linksVanished(DeviceId deviceId) {
        this.vanishedDpid.add(deviceId);
    }

    public List<DeviceId> vanishedDpid() {
        return this.vanishedDpid;
    }

    public List<Long> vanishedPort() {
        return this.vanishedPort;
    }

    public Map<DeviceId, DeviceId> discoveredLinks() {
        return this.discoveredLinks;
    }

    public Map<LinkKey, LinkDescription> discoveredLinkDescriptions() {
        return this.discoveredLinkDescriptions;
    }
}

