/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.collect.Lists;
import com.google.common.testing.EqualsTester;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiMatchFieldId;
import org.onosproject.net.pi.runtime.PiFieldMatch;
import org.onosproject.net.pi.runtime.PiLpmFieldMatch;
import org.onosproject.net.pi.runtime.PiMatchKey;

public class PiMatchKeyTest {
    private final ImmutableByteSequence value1 = ImmutableByteSequence.copyFrom((int)0xA010101);
    private final ImmutableByteSequence value2 = ImmutableByteSequence.copyFrom((int)167837954);
    private int prefixLength = 24;
    private final PiMatchFieldId piMatchField1 = PiMatchFieldId.of((String)"ipv4_t.srcAddr");
    private final PiMatchFieldId piMatchField2 = PiMatchFieldId.of((String)"ipv4_t.dstAddr");
    private PiLpmFieldMatch piLpmFieldMatch1 = new PiLpmFieldMatch(this.piMatchField1, this.value1, this.prefixLength);
    private PiLpmFieldMatch piLpmFieldMatch2 = new PiLpmFieldMatch(this.piMatchField2, this.value2, this.prefixLength);
    private final PiMatchKey piMatchKey1 = PiMatchKey.builder().addFieldMatch((PiFieldMatch)this.piLpmFieldMatch1).build();
    private final PiMatchKey sameAsPiMatchKey1 = PiMatchKey.builder().addFieldMatch((PiFieldMatch)this.piLpmFieldMatch1).build();
    private final PiMatchKey piMatchKey2 = PiMatchKey.builder().addFieldMatch((PiFieldMatch)this.piLpmFieldMatch2).build();

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PiMatchKey.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.piMatchKey1, this.sameAsPiMatchKey1}).addEqualityGroup(new Object[]{PiMatchKey.EMPTY, PiMatchKey.EMPTY}).addEqualityGroup(new Object[]{this.piMatchKey2}).testEquals();
    }

    @Test
    public void testMethods() {
        ArrayList piFieldMatches = Lists.newArrayList();
        piFieldMatches.add(this.piLpmFieldMatch1);
        piFieldMatches.add(this.piLpmFieldMatch2);
        PiMatchKey piMatchKey = PiMatchKey.builder().addFieldMatches((Collection)piFieldMatches).build();
        MatcherAssert.assertThat((Object)piMatchKey, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((String)"Incorrect members value", (boolean)CollectionUtils.isEqualCollection((Collection)piMatchKey.fieldMatches(), (Collection)piFieldMatches));
    }
}

