/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.provider;

import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.provider.AbstractProviderRegistry;
import org.onosproject.net.provider.AbstractProviderService;
import org.onosproject.net.provider.Provider;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.provider.TestProvider;

public class AbstractProviderRegistryTest {
    @Test
    public void basics() {
        TestProviderRegistry registry = new TestProviderRegistry();
        Assert.assertEquals((String)"incorrect provider count", (long)0L, (long)registry.getProviders().size());
        ProviderId fooId = new ProviderId("of", "foo");
        TestProvider pFoo = new TestProvider(fooId);
        TestProviderService psFoo = (TestProviderService)registry.register((Provider)pFoo);
        Assert.assertEquals((String)"incorrect provider count", (long)1L, (long)registry.getProviders().size());
        MatcherAssert.assertThat((String)"provider not found", (boolean)registry.getProviders().contains(fooId));
        Assert.assertEquals((String)"incorrect provider", (Object)psFoo.provider(), (Object)((Object)pFoo));
        ProviderId barId = new ProviderId("snmp", "bar");
        TestProvider pBar = new TestProvider(barId);
        TestProviderService psBar = (TestProviderService)registry.register((Provider)pBar);
        Assert.assertEquals((String)"incorrect provider count", (long)2L, (long)registry.getProviders().size());
        MatcherAssert.assertThat((String)"provider not found", (boolean)registry.getProviders().contains(barId));
        Assert.assertEquals((String)"incorrect provider", (Object)psBar.provider(), (Object)((Object)pBar));
        psFoo.checkValidity();
        registry.unregister((Provider)pFoo);
        psBar.checkValidity();
        Assert.assertEquals((String)"incorrect provider count", (long)1L, (long)registry.getProviders().size());
        MatcherAssert.assertThat((String)"provider not found", (boolean)registry.getProviders().contains(barId));
    }

    @Test
    public void ancillaryProviders() {
        TestProviderRegistry registry = new TestProviderRegistry();
        TestProvider pFoo = new TestProvider(new ProviderId("of", "foo"));
        TestProvider pBar = new TestProvider(new ProviderId("of2", "bar"));
        TestProvider aBar = new TestProvider(new ProviderId("of", "foo", true));
        registry.register((Provider)pFoo);
        registry.register((Provider)pBar);
        registry.register((Provider)aBar);
        Assert.assertEquals((String)"incorrect provider count", (long)2L, (long)registry.getProviders().size());
    }

    @Test(expected=IllegalStateException.class)
    public void duplicateRegistration() {
        TestProviderRegistry registry = new TestProviderRegistry();
        TestProvider pFoo = new TestProvider(new ProviderId("of", "foo"));
        registry.register((Provider)pFoo);
        registry.register((Provider)pFoo);
    }

    @Test(expected=IllegalStateException.class)
    public void duplicateSchemeRegistration() {
        TestProviderRegistry registry = new TestProviderRegistry();
        TestProvider pFoo = new TestProvider(new ProviderId("of", "foo"));
        TestProvider pBar = new TestProvider(new ProviderId("of", "bar"));
        registry.register((Provider)pFoo);
        registry.register((Provider)pBar);
    }

    @Test
    public void voidUnregistration() {
        TestProviderRegistry registry = new TestProviderRegistry();
        registry.unregister((Provider)new TestProvider(new ProviderId("of", "foo")));
    }

    @Test(expected=IllegalStateException.class)
    public void unregistration() {
        TestProviderRegistry registry = new TestProviderRegistry();
        TestProvider pFoo = new TestProvider(new ProviderId("of", "foo"));
        TestProviderService psFoo = (TestProviderService)registry.register((Provider)pFoo);
        registry.unregister((Provider)pFoo);
        psFoo.checkValidity();
    }

    private class TestProviderRegistry
    extends AbstractProviderRegistry<TestProvider, TestProviderService> {
        private TestProviderRegistry() {
        }

        protected TestProviderService createProviderService(TestProvider provider) {
            return new TestProviderService(provider);
        }
    }

    private class TestProviderService
    extends AbstractProviderService<TestProvider> {
        protected TestProviderService(TestProvider provider) {
            super((Provider)provider);
        }
    }
}

