/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.resource;

import com.google.common.testing.EqualsTester;
import org.junit.Test;
import org.onlab.packet.VlanId;
import org.onlab.util.Identifier;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceConsumerId;
import org.onosproject.net.resource.Resources;

public class ResourceAllocationTest {
    private static final DeviceId D1 = DeviceId.deviceId((String)"of:001");
    private static final DeviceId D2 = DeviceId.deviceId((String)"of:002");
    private static final PortNumber P1 = PortNumber.portNumber((long)1L);
    private static final PortNumber P2 = PortNumber.portNumber((long)2L);
    private static final VlanId VLAN1 = VlanId.vlanId((short)100);
    private static final VlanId VLAN2 = VlanId.vlanId((short)200);
    private static final TestResourceConsumer RC2 = new TestResourceConsumer(2L);
    private static final ResourceConsumerId RCID1 = ResourceConsumerId.of((long)30L, IntentId.class);
    private static final ResourceConsumerId RCID2 = ResourceConsumerId.of((Identifier)RC2);

    @Test
    public void testEquals() {
        ResourceAllocation alloc1 = new ResourceAllocation((Resource)Resources.discrete((DeviceId)D1, (PortNumber)P1, (Object[])new Object[]{VLAN1}).resource(), RCID1);
        ResourceAllocation sameAsAlloc1 = new ResourceAllocation((Resource)Resources.discrete((DeviceId)D1, (PortNumber)P1, (Object[])new Object[]{VLAN1}).resource(), RCID1);
        ResourceAllocation alloc2 = new ResourceAllocation((Resource)Resources.discrete((DeviceId)D2, (PortNumber)P2, (Object[])new Object[]{VLAN2}).resource(), RCID2);
        ResourceAllocation sameAsAlloc2 = new ResourceAllocation((Resource)Resources.discrete((DeviceId)D2, (PortNumber)P2, (Object[])new Object[]{VLAN2}).resource(), RCID2);
        new EqualsTester().addEqualityGroup(new Object[]{alloc1, sameAsAlloc1}).addEqualityGroup(new Object[]{alloc2, sameAsAlloc2}).testEquals();
    }

    private static class TestResourceConsumer
    extends Identifier<Long>
    implements ResourceConsumer {
        public TestResourceConsumer(long idValue) {
            super((Object)idValue);
        }

        public ResourceConsumerId consumerId() {
            return ResourceConsumerId.of((Identifier)this);
        }
    }
}

