/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.table.cell;

import java.util.Locale;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onosproject.ui.table.CellFormatter;
import org.onosproject.ui.table.cell.NumberFormatter;

public class NumberFormatterTest {
    private CellFormatter f5dp = NumberFormatter.TO_5DP;
    private CellFormatter fInt = NumberFormatter.INTEGER;
    private static Locale systemLocale;

    @BeforeClass
    public static void classSetup() {
        systemLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
    }

    @AfterClass
    public static void classTeardown() {
        Locale.setDefault(systemLocale);
    }

    @Test
    public void defaultNullValue() {
        Assert.assertEquals((String)"default null value", (Object)"", (Object)this.f5dp.format(null));
    }

    @Test
    public void defaultZero() {
        Assert.assertEquals((String)"default zero", (Object)"0.00000", (Object)this.f5dp.format((Object)0));
    }

    @Test
    public void defaultFifty() {
        Assert.assertEquals((String)"default fifty", (Object)"50.00000", (Object)this.f5dp.format((Object)50));
    }

    @Test
    public void default2G() {
        Assert.assertEquals((String)"default 2G", (Object)"2,000.00000", (Object)this.f5dp.format((Object)2000));
    }

    @Test
    public void integerNullValue() {
        Assert.assertEquals((String)"integer null value", (Object)"", (Object)this.fInt.format(null));
    }

    @Test
    public void integerZero() {
        Assert.assertEquals((String)"integer zero", (Object)"0", (Object)this.fInt.format((Object)0));
    }

    @Test
    public void integerFifty() {
        Assert.assertEquals((String)"integer fifty", (Object)"50", (Object)this.fInt.format((Object)50));
    }

    @Test
    public void integer2G() {
        Assert.assertEquals((String)"integer 2G", (Object)"2,000", (Object)this.fInt.format((Object)2000));
    }

    @Test
    public void integer5M() {
        Assert.assertEquals((String)"integer 5M", (Object)"5,000,042", (Object)this.fInt.format((Object)5000042));
    }
}

