/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.topo;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onosproject.ui.topo.ButtonId;
import org.onosproject.ui.topo.PropertyPanel;

public class PropertyPanelTest {
    private static final String TITLE_ORIG = "Original Title";
    private static final String GLYPH_ORIG = "Original glyph ID";
    private static final String TITLE_NEW = "New Title";
    private static final String GLYPH_NEW = "New glyph ID";
    private static final String SOME_IDENTIFICATION = "It's Me!";
    private static final String KEY_A = "A";
    private static final String KEY_B = "B";
    private static final String KEY_C = "C";
    private static final String SEP = "-";
    private static final String KEY_Z = "Z";
    private static final String LABEL_A = "labA";
    private static final String LABEL_B = "labB";
    private static final String LABEL_C = "labC";
    private static final String LABEL_Z = "labZ";
    private static final String VALUE_A = "Hay";
    private static final String VALUE_B = "Bee";
    private static final String VALUE_C = "Sea";
    private static final String VALUE_Z = "Zed";
    private static final Map<String, PropertyPanel.Prop> PROP_MAP = new HashMap<String, PropertyPanel.Prop>();
    private PropertyPanel pp;
    private static final ButtonId BD_A = new ButtonId("A");
    private static final ButtonId BD_B = new ButtonId("B");
    private static final ButtonId BD_C = new ButtonId("C");
    private static final ButtonId BD_Z = new ButtonId("Z");

    @BeforeClass
    public static void setUpClass() {
        PROP_MAP.put(KEY_A, new PropertyPanel.Prop(KEY_A, LABEL_A, VALUE_A));
        PROP_MAP.put(KEY_B, new PropertyPanel.Prop(KEY_B, LABEL_B, VALUE_B));
        PROP_MAP.put(KEY_C, new PropertyPanel.Prop(KEY_C, LABEL_C, VALUE_C));
        PROP_MAP.put(KEY_Z, new PropertyPanel.Prop(KEY_Z, LABEL_Z, VALUE_Z));
        PROP_MAP.put(SEP, (PropertyPanel.Prop)new PropertyPanel.Separator());
    }

    @Test
    public void basic() {
        this.pp = new EnglishPropertyPanel(TITLE_ORIG, GLYPH_ORIG);
        Assert.assertEquals((String)"wrong title", (Object)TITLE_ORIG, (Object)this.pp.title());
        Assert.assertEquals((String)"wrong glyph", (Object)GLYPH_ORIG, (Object)this.pp.glyphId());
        Assert.assertNull((String)"id?", (Object)this.pp.id());
        Assert.assertEquals((String)"unexpected props", (long)0L, (long)this.pp.properties().size());
        Assert.assertEquals((String)"unexpected buttons", (long)0L, (long)this.pp.buttons().size());
    }

    @Test
    public void changeTitle() {
        this.basic();
        this.pp.title(TITLE_NEW);
        Assert.assertEquals((String)"wrong title", (Object)TITLE_NEW, (Object)this.pp.title());
    }

    @Test
    public void changeGlyph() {
        this.basic();
        this.pp.glyphId(GLYPH_NEW);
        Assert.assertEquals((String)"wrong glyph", (Object)GLYPH_NEW, (Object)this.pp.glyphId());
    }

    @Test
    public void setId() {
        this.basic();
        this.pp.id(SOME_IDENTIFICATION);
        Assert.assertEquals((String)"wrong id", (Object)SOME_IDENTIFICATION, (Object)this.pp.id());
    }

    private void validateProps(String ... keys) {
        Iterator iter = this.pp.properties().iterator();
        for (String k : keys) {
            PropertyPanel.Prop exp = PROP_MAP.get(k);
            PropertyPanel.Prop act = (PropertyPanel.Prop)iter.next();
            Assert.assertEquals((String)"Bad prop sequence", (Object)exp, (Object)act);
        }
    }

    private void validateProp(String key, String expValue) {
        Iterator iter = this.pp.properties().iterator();
        PropertyPanel.Prop prop = null;
        while (iter.hasNext()) {
            PropertyPanel.Prop p = (PropertyPanel.Prop)iter.next();
            if (!p.key().equals(key)) continue;
            prop = p;
            break;
        }
        if (prop == null) {
            Assert.fail((String)("no prop found with key: " + key));
        }
        Assert.assertEquals((String)"Wrong prop value", (Object)expValue, (Object)prop.value());
    }

    @Test
    public void props() {
        this.basic();
        this.pp.addProp(KEY_A, KEY_A, VALUE_A).addProp(KEY_B, KEY_B, VALUE_B).addProp(KEY_C, KEY_C, VALUE_C);
        Assert.assertEquals((String)"bad props", (long)3L, (long)this.pp.properties().size());
        this.validateProps(KEY_A, KEY_B, KEY_C);
    }

    @Test
    public void localizedProp() {
        this.basic();
        this.pp.addProp(KEY_A, LABEL_A, VALUE_A);
        PropertyPanel.Prop p = (PropertyPanel.Prop)this.pp.properties().get(0);
        Assert.assertEquals((String)"wrong key", (Object)KEY_A, (Object)p.key());
        Assert.assertEquals((String)"wrong label", (Object)LABEL_A, (Object)p.label());
        Assert.assertEquals((String)"wrong value", (Object)VALUE_A, (Object)p.value());
    }

    @Test
    public void nonLocalizedProp() {
        this.basic();
        this.pp.addProp(KEY_A, KEY_A, VALUE_A);
        PropertyPanel.Prop p = (PropertyPanel.Prop)this.pp.properties().get(0);
        Assert.assertEquals((String)"wrong key", (Object)KEY_A, (Object)p.key());
        Assert.assertEquals((String)"wrong label", (Object)KEY_A, (Object)p.label());
        Assert.assertEquals((String)"wrong value", (Object)VALUE_A, (Object)p.value());
    }

    @Test
    public void separator() {
        this.props();
        this.pp.addSeparator().addProp(KEY_Z, KEY_Z, VALUE_Z);
        Assert.assertEquals((String)"bad props", (long)5L, (long)this.pp.properties().size());
        this.validateProps(KEY_A, KEY_B, KEY_C, SEP, KEY_Z);
    }

    @Test
    public void removeAllProps() {
        this.props();
        Assert.assertEquals((String)"wrong props", (long)3L, (long)this.pp.properties().size());
        this.pp.removeAllProps();
        Assert.assertEquals((String)"unexpected props", (long)0L, (long)this.pp.properties().size());
    }

    @Test
    public void adjustProps() {
        this.props();
        this.pp.removeProps(new String[]{KEY_B, KEY_A});
        this.pp.addProp(KEY_Z, KEY_Z, VALUE_Z);
        this.validateProps(KEY_C, KEY_Z);
    }

    @Test
    public void intValues() {
        this.basic();
        this.pp.addProp(KEY_A, KEY_A, 200).addProp(KEY_B, KEY_B, 2000).addProp(KEY_C, KEY_C, 1234567);
        this.validateProp(KEY_A, "200");
        this.validateProp(KEY_B, "2,000");
        this.validateProp(KEY_C, "1,234,567");
    }

    @Test
    public void longValues() {
        this.basic();
        this.pp.addProp(KEY_A, KEY_A, 200L).addProp(KEY_B, KEY_B, 2000L).addProp(KEY_C, KEY_C, 1234567L).addProp(KEY_Z, KEY_Z, Long.MAX_VALUE);
        this.validateProp(KEY_A, "200");
        this.validateProp(KEY_B, "2,000");
        this.validateProp(KEY_C, "1,234,567");
        this.validateProp(KEY_Z, "9,223,372,036,854,775,807");
    }

    @Test
    public void objectValue() {
        this.basic();
        this.pp.addProp(KEY_A, KEY_A, (Object)new FooClass("a")).addProp(KEY_B, KEY_B, (Object)new FooClass("bxyyzy"), "[xz]");
        this.validateProp(KEY_A, ">a<");
        this.validateProp(KEY_B, ">byyy<");
    }

    private void verifyButtons(String ... keys) {
        Iterator iter = this.pp.buttons().iterator();
        for (String k : keys) {
            Assert.assertEquals((String)"wrong button", (Object)k, (Object)((ButtonId)iter.next()).id());
        }
        Assert.assertFalse((String)"too many buttons", (boolean)iter.hasNext());
    }

    @Test
    public void buttons() {
        this.basic();
        this.pp.addButton(BD_A).addButton(BD_B);
        Assert.assertEquals((String)"wrong buttons", (long)2L, (long)this.pp.buttons().size());
        this.verifyButtons(KEY_A, KEY_B);
        this.pp.removeButtons(new ButtonId[]{BD_B}).addButton(BD_C).addButton(BD_Z);
        Assert.assertEquals((String)"wrong buttons", (long)3L, (long)this.pp.buttons().size());
        this.verifyButtons(KEY_A, KEY_C, KEY_Z);
        this.pp.removeAllButtons().addButton(BD_B);
        Assert.assertEquals((String)"wrong buttons", (long)1L, (long)this.pp.buttons().size());
        this.verifyButtons(KEY_B);
    }

    private static class FooClass {
        private final String s;

        FooClass(String s) {
            this.s = s;
        }

        public String toString() {
            return ">" + this.s + "<";
        }
    }

    private static final class EnglishPropertyPanel
    extends PropertyPanel {
        private static final NumberFormat ENGLISH_FORMATTER = NumberFormat.getInstance(Locale.ENGLISH);

        public EnglishPropertyPanel(String title, String glyphId) {
            super(title, glyphId);
        }

        protected NumberFormat formatter() {
            return ENGLISH_FORMATTER;
        }
    }
}

