/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.model;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import org.onlab.util.Identifier;
import org.onosproject.net.flow.TableId;

@Beta
public final class PiTableId
extends Identifier<String>
implements TableId {
    private PiTableId(String name) {
        super((Object)name);
    }

    public static PiTableId of(String name) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Name can't be empty");
        return new PiTableId(name);
    }

    @Override
    public TableId.Type type() {
        return TableId.Type.PIPELINE_INDEPENDENT;
    }

    @Override
    public int compareTo(TableId other) {
        if (this.type() != other.type()) {
            return this.type().compareTo(other.type());
        }
        PiTableId piTableId = (PiTableId)other;
        Preconditions.checkNotNull((Object)((String)this.identifier), (Object)"PiTableId identifier should not be null");
        Preconditions.checkNotNull((Object)((String)piTableId.identifier), (Object)"PiTableId identifier should not be null");
        return ((String)this.identifier).compareTo((String)piTableId.identifier);
    }
}

