/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.ConfigApplyDelegate;
import org.onosproject.net.config.basics.BasicDeviceConfig;
import org.onosproject.net.key.DeviceKeyId;

public class BasicDeviceConfigTest {
    private static final String DRIVER = "fooDriver";
    private static final String MANUFACTURER = "fooManufacturer";
    private static final String HW_VERSION = "0.0";
    private static final String SW_VERSION = "0.0";
    private static final String SERIAL = "1234";
    private static final String MANAGEMENT_ADDRESS = "12.34.56.78:99";
    private static final DeviceKeyId DEVICE_KEY_ID = DeviceKeyId.deviceKeyId((String)"fooDeviceKeyId");
    private static final String DRIVER_NEW = "barDriver";
    private static final String MANUFACTURER_NEW = "barManufacturer";
    private static final String HW_VERSION_NEW = "1.1";
    private static final String SW_VERSION_NEW = "1.1";
    private static final String SERIAL_NEW = "5678";
    private static final String MANAGEMENT_ADDRESS_NEW = "99.87.65.43:12";
    private static final DeviceKeyId DEVICE_KEY_ID_NEW = DeviceKeyId.deviceKeyId((String)"barDeviceKeyId");
    private static final String NAME1 = "fooProtocol:fooIP:fooPort";
    private final ConfigApplyDelegate delegate = config -> {};
    private final ObjectMapper mapper = new ObjectMapper();
    private static final BasicDeviceConfig SW_BDC = new BasicDeviceConfig();

    @Before
    public void setUp() {
        SW_BDC.init((Object)DeviceId.deviceId((String)NAME1), NAME1, (JsonNode)JsonNodeFactory.instance.objectNode(), this.mapper, this.delegate);
        SW_BDC.type(Device.Type.SWITCH).manufacturer(MANUFACTURER).hwVersion("0.0").swVersion("0.0").serial(SERIAL).managementAddress(MANAGEMENT_ADDRESS).driver(DRIVER).deviceKeyId(DEVICE_KEY_ID);
    }

    @Test
    public void testCorrectConfiguration() {
        Assert.assertTrue((String)"Configuration contains not valid fields", (boolean)SW_BDC.isValid());
        Assert.assertEquals((String)"Incorrect type", (Object)Device.Type.SWITCH, (Object)SW_BDC.type());
        Assert.assertEquals((String)"Incorrect driver", (Object)DRIVER, (Object)SW_BDC.driver());
        Assert.assertEquals((String)"Incorrect manufacturer", (Object)MANUFACTURER, (Object)SW_BDC.manufacturer());
        Assert.assertEquals((String)"Incorrect HwVersion", (Object)"0.0", (Object)SW_BDC.hwVersion());
        Assert.assertEquals((String)"Incorrect swVersion", (Object)"0.0", (Object)SW_BDC.swVersion());
        Assert.assertEquals((String)"Incorrect serial", (Object)SERIAL, (Object)SW_BDC.serial());
        Assert.assertEquals((String)"Incorrect management Address", (Object)MANAGEMENT_ADDRESS, (Object)SW_BDC.managementAddress());
        Assert.assertEquals((String)"Incorrect deviceKeyId", (Object)DEVICE_KEY_ID, (Object)SW_BDC.deviceKeyId());
    }

    @Test
    public void testSetType() {
        SW_BDC.type(Device.Type.OTN);
        Assert.assertEquals((String)"Incorrect type", (Object)Device.Type.OTN, (Object)SW_BDC.type());
    }

    @Test
    public void testSetDriver() {
        SW_BDC.driver(DRIVER_NEW);
        Assert.assertEquals((String)"Incorrect driver", (Object)DRIVER_NEW, (Object)SW_BDC.driver());
    }

    @Test
    public void testSetManufacturer() {
        SW_BDC.manufacturer(MANUFACTURER_NEW);
        Assert.assertEquals((String)"Incorrect manufacturer", (Object)MANUFACTURER_NEW, (Object)SW_BDC.manufacturer());
    }

    @Test
    public void testSetHwVersion() {
        SW_BDC.hwVersion("1.1");
        Assert.assertEquals((String)"Incorrect HwVersion", (Object)"1.1", (Object)SW_BDC.hwVersion());
    }

    @Test
    public void testSetSwVersion() {
        SW_BDC.swVersion("1.1");
        Assert.assertEquals((String)"Incorrect swVersion", (Object)"1.1", (Object)SW_BDC.swVersion());
    }

    @Test
    public void testSetSerial() {
        SW_BDC.serial(SERIAL_NEW);
        Assert.assertEquals((String)"Incorrect serial", (Object)SERIAL_NEW, (Object)SW_BDC.serial());
    }

    @Test
    public void testSetManagementAddress() {
        SW_BDC.managementAddress(MANAGEMENT_ADDRESS_NEW);
        Assert.assertEquals((String)"Incorrect managementAddress", (Object)MANAGEMENT_ADDRESS_NEW, (Object)SW_BDC.managementAddress());
    }

    @Test
    public void testSetDeviceKeyId() {
        SW_BDC.deviceKeyId(DEVICE_KEY_ID_NEW);
        Assert.assertEquals((String)"Incorrect deviceKeyId", (Object)DEVICE_KEY_ID_NEW, (Object)SW_BDC.deviceKeyId());
        SW_BDC.deviceKeyId(null);
        Assert.assertEquals((String)"Incorrect deviceKeyId", null, (Object)SW_BDC.deviceKeyId());
    }
}

