/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.meter;

import com.google.common.testing.EqualsTester;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.DefaultBand;
import org.onosproject.net.meter.DefaultMeter;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterId;

public class DefaultMeterTest {
    private Meter m1;
    private Meter sameAsm1;
    private Meter m2;
    private Meter m3;

    @Before
    public void setup() {
        Band band = DefaultBand.builder().ofType(Band.Type.DROP).withRate(500L).build();
        Band band1 = DefaultBand.builder().ofType(Band.Type.REMARK).withRate(500L).dropPrecedence((short)1).build();
        this.m1 = DefaultMeter.builder().forDevice(NetTestTools.did("1")).fromApp(NetTestTools.APP_ID).withId(MeterId.meterId((long)1L)).withUnit(Meter.Unit.KB_PER_SEC).withBands(Collections.singletonList(band)).build();
        this.sameAsm1 = DefaultMeter.builder().forDevice(NetTestTools.did("1")).fromApp(NetTestTools.APP_ID).withId(MeterId.meterId((long)1L)).withUnit(Meter.Unit.KB_PER_SEC).withBands(Collections.singletonList(band)).build();
        this.m2 = DefaultMeter.builder().forDevice(NetTestTools.did("2")).fromApp(NetTestTools.APP_ID).withId(MeterId.meterId((long)2L)).withUnit(Meter.Unit.KB_PER_SEC).withBands(Collections.singletonList(band)).build();
        this.m3 = DefaultMeter.builder().forDevice(NetTestTools.did("3")).fromApp(NetTestTools.APP_ID).withId(MeterId.meterId((long)3L)).withUnit(Meter.Unit.KB_PER_SEC).withBands(Collections.singletonList(band1)).build();
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.m1, this.sameAsm1}).addEqualityGroup(new Object[]{this.m2}).addEqualityGroup(new Object[]{this.m3}).testEquals();
    }

    @Test
    public void testConstruction() {
        DefaultMeter m = (DefaultMeter)this.m1;
        MatcherAssert.assertThat((Object)m.deviceId(), (Matcher)Matchers.is((Object)NetTestTools.did("1")));
        MatcherAssert.assertThat((Object)m.appId(), (Matcher)Matchers.is((Object)NetTestTools.APP_ID));
        MatcherAssert.assertThat((Object)m.id(), (Matcher)Matchers.is((Object)MeterId.meterId((long)1L)));
        MatcherAssert.assertThat((Object)m.isBurst(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)m.life(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)m.bytesSeen(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)m.packetsSeen(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((Object)m.referenceCount(), (Matcher)Matchers.is((Object)0L));
    }
}

