/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import java.util.concurrent.CompletableFuture;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.store.primitives.AsyncAtomicCounterAdapter;
import org.onosproject.store.primitives.DefaultAtomicCounter;
import org.onosproject.store.primitives.TestingCompletableFutures;
import org.onosproject.store.service.AsyncAtomicCounter;
import org.onosproject.store.service.StorageException;

public class DefaultAtomicCounterTest {
    private static final long INITIAL_VALUE = 33L;
    private static final long ADDED_VALUE = 44L;
    private DefaultAtomicCounter atomicCounter;

    private DefaultAtomicCounter create() {
        AsyncAtomicCounter atomicCounter = (AsyncAtomicCounter)AsyncAtomicCounterAdapter.builder().build();
        DefaultAtomicCounter counter = new DefaultAtomicCounter(atomicCounter, 1000L);
        counter.set(33L);
        MatcherAssert.assertThat((Object)counter.get(), (Matcher)Matchers.is((Object)33L));
        return counter;
    }

    @Before
    public void setUpCounter() {
        this.atomicCounter = this.create();
    }

    @Test
    public void testConstruction() {
        MatcherAssert.assertThat((Object)this.atomicCounter, (Matcher)Matchers.notNullValue());
    }

    @Test
    public void testIncrements() {
        long beforeIncrement = this.atomicCounter.getAndIncrement();
        MatcherAssert.assertThat((Object)beforeIncrement, (Matcher)Matchers.is((Object)33L));
        MatcherAssert.assertThat((Object)this.atomicCounter.get(), (Matcher)Matchers.is((Object)34L));
        this.atomicCounter.set(33L);
        long afterIncrement = this.atomicCounter.incrementAndGet();
        MatcherAssert.assertThat((Object)afterIncrement, (Matcher)Matchers.is((Object)34L));
        MatcherAssert.assertThat((Object)this.atomicCounter.get(), (Matcher)Matchers.is((Object)34L));
    }

    @Test
    public void testAdds() {
        long beforeIncrement = this.atomicCounter.getAndAdd(44L);
        MatcherAssert.assertThat((Object)beforeIncrement, (Matcher)Matchers.is((Object)33L));
        MatcherAssert.assertThat((Object)this.atomicCounter.get(), (Matcher)Matchers.is((Object)77L));
        this.atomicCounter.set(33L);
        long afterIncrement = this.atomicCounter.addAndGet(44L);
        MatcherAssert.assertThat((Object)afterIncrement, (Matcher)Matchers.is((Object)77L));
        MatcherAssert.assertThat((Object)this.atomicCounter.get(), (Matcher)Matchers.is((Object)77L));
    }

    @Test
    public void testCompareAndSet() {
        boolean compareTrue = this.atomicCounter.compareAndSet(33L, 44L);
        MatcherAssert.assertThat((Object)compareTrue, (Matcher)Matchers.is((Object)true));
        boolean compareFalse = this.atomicCounter.compareAndSet(33L, 44L);
        MatcherAssert.assertThat((Object)compareFalse, (Matcher)Matchers.is((Object)false));
    }

    @Test(expected=StorageException.Timeout.class)
    public void testTimeout() {
        AtomicCounterWithErrors atomicCounter = new AtomicCounterWithErrors();
        atomicCounter.setErrorState(TestingCompletableFutures.ErrorState.TIMEOUT_EXCEPTION);
        DefaultAtomicCounter counter = new DefaultAtomicCounter((AsyncAtomicCounter)atomicCounter, 1000L);
        counter.get();
    }

    @Test(expected=StorageException.Interrupted.class)
    public void testInterrupted() {
        AtomicCounterWithErrors atomicCounter = new AtomicCounterWithErrors();
        atomicCounter.setErrorState(TestingCompletableFutures.ErrorState.INTERRUPTED_EXCEPTION);
        DefaultAtomicCounter counter = new DefaultAtomicCounter((AsyncAtomicCounter)atomicCounter, 1000L);
        counter.get();
    }

    @Test(expected=StorageException.class)
    public void testExecutionError() {
        AtomicCounterWithErrors atomicCounter = new AtomicCounterWithErrors();
        atomicCounter.setErrorState(TestingCompletableFutures.ErrorState.EXECUTION_EXCEPTION);
        DefaultAtomicCounter counter = new DefaultAtomicCounter((AsyncAtomicCounter)atomicCounter, 1000L);
        counter.get();
    }

    class AtomicCounterWithErrors
    extends AsyncAtomicCounterAdapter {
        TestingCompletableFutures.ErrorState errorState = TestingCompletableFutures.ErrorState.NONE;

        void setErrorState(TestingCompletableFutures.ErrorState errorState) {
            this.errorState = errorState;
        }

        AtomicCounterWithErrors() {
        }

        @Override
        public CompletableFuture<Long> get() {
            return TestingCompletableFutures.createFuture(this.errorState);
        }
    }
}

