/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.codec;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import org.onosproject.codec.CodecContext;

public abstract class JsonCodec<T> {
    public ObjectNode encode(T entity, CodecContext context) {
        throw new UnsupportedOperationException("encode() not supported");
    }

    public T decode(ObjectNode json, CodecContext context) {
        throw new UnsupportedOperationException("decode() not supported");
    }

    public ArrayNode encode(Iterable<T> entities, CodecContext context) {
        ArrayNode result = context.mapper().createArrayNode();
        for (T entity : entities) {
            result.add((JsonNode)this.encode(entity, context));
        }
        return result;
    }

    public List<T> decode(ArrayNode json, CodecContext context) {
        ArrayList<T> result = new ArrayList<T>();
        for (JsonNode node : json) {
            result.add(this.decode((ObjectNode)node, context));
        }
        return result;
    }

    protected static ObjectNode get(ObjectNode parent, String childName) {
        JsonNode node = parent.path(childName);
        return node.isObject() && !node.isNull() ? (ObjectNode)node : null;
    }

    protected static ObjectNode get(JsonNode parent, int childIndex) {
        JsonNode node = parent.path(childIndex);
        return node.isObject() && !node.isNull() ? (ObjectNode)node : null;
    }
}

