/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.ResourceGroup;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.Key;

public final class FlowObjectiveIntent
extends Intent {
    private final List<Objective> objectives;
    private final List<DeviceId> devices;

    protected FlowObjectiveIntent() {
        this.objectives = null;
        this.devices = null;
    }

    public FlowObjectiveIntent(ApplicationId appId, Key key, List<DeviceId> devices, List<Objective> objectives, Collection<NetworkResource> resources, ResourceGroup resourceGroup) {
        super(appId, key, resources, 100, resourceGroup);
        Preconditions.checkArgument((devices.size() == objectives.size() ? 1 : 0) != 0, (Object)"Number of devices and objectives does not match");
        this.objectives = ImmutableList.copyOf(objectives);
        this.devices = ImmutableList.copyOf(devices);
    }

    public List<Objective> objectives() {
        return this.objectives;
    }

    public List<DeviceId> devices() {
        return this.devices;
    }

    @Override
    public boolean isInstallable() {
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id()).add("key", (Object)this.key()).add("appId", (Object)this.appId()).add("resources", this.resources()).add("device", this.devices()).add("objectives", this.objectives()).add("resourceGroup", (Object)this.resourceGroup()).toString();
    }
}

