/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject;

import com.google.common.testing.EqualsTester;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.core.Version;

public class VersionTest {
    @Test
    public void fromParts() {
        Version v = Version.version((int)1, (int)2, (String)"3", (String)"4321");
        Assert.assertEquals((String)"wrong major", (long)1L, (long)v.major());
        Assert.assertEquals((String)"wrong minor", (long)2L, (long)v.minor());
        Assert.assertEquals((String)"wrong patch", (Object)"3", (Object)v.patch());
        Assert.assertEquals((String)"wrong build", (Object)"4321", (Object)v.build());
    }

    @Test
    public void fromString() {
        Version v = Version.version((String)"1.2.3.4321");
        Assert.assertEquals((String)"wrong major", (long)1L, (long)v.major());
        Assert.assertEquals((String)"wrong minor", (long)2L, (long)v.minor());
        Assert.assertEquals((String)"wrong patch", (Object)"3", (Object)v.patch());
        Assert.assertEquals((String)"wrong build", (Object)"4321", (Object)v.build());
    }

    @Test
    public void snapshot() {
        Version v = Version.version((String)"1.2.3-SNAPSHOT");
        Assert.assertEquals((String)"wrong major", (long)1L, (long)v.major());
        Assert.assertEquals((String)"wrong minor", (long)2L, (long)v.minor());
        Assert.assertEquals((String)"wrong patch", (Object)"3", (Object)v.patch());
        Assert.assertEquals((String)"wrong build", (Object)"SNAPSHOT", (Object)v.build());
    }

    @Test
    public void shortNumber() {
        Version v = Version.version((String)"1.2.3");
        Assert.assertEquals((String)"wrong major", (long)1L, (long)v.major());
        Assert.assertEquals((String)"wrong minor", (long)2L, (long)v.minor());
        Assert.assertEquals((String)"wrong patch", (Object)"3", (Object)v.patch());
        Assert.assertEquals((String)"wrong build", null, (Object)v.build());
    }

    @Test
    public void minimal() {
        Version v = Version.version((String)"1.4");
        Assert.assertEquals((String)"wrong major", (long)1L, (long)v.major());
        Assert.assertEquals((String)"wrong minor", (long)4L, (long)v.minor());
        Assert.assertEquals((String)"wrong patch", null, (Object)v.patch());
        Assert.assertEquals((String)"wrong build", null, (Object)v.build());
    }

    @Test
    public void testToFromInt() {
        Version version1 = Version.version((String)"1.2");
        Version version2 = Version.fromInt((int)version1.toInt());
        Assert.assertEquals((Object)version2, (Object)Version.version((int)1, (int)2, (String)"0", (String)"0"));
        version1 = Version.version((String)"1.2.foo.bar");
        version2 = Version.fromInt((int)version1.toInt());
        Assert.assertEquals((Object)version2, (Object)Version.version((int)1, (int)2, (String)"0", (String)"0"));
        version1 = Version.version((String)"1.2.3");
        version2 = Version.fromInt((int)version1.toInt());
        Assert.assertEquals((Object)version2, (Object)Version.version((int)1, (int)2, (String)"3", (String)"0"));
        version1 = Version.version((String)"1.2.3-SNAPSHOT");
        version2 = Version.fromInt((int)version1.toInt());
        Assert.assertEquals((Object)version2, (Object)Version.version((int)1, (int)2, (String)"3", (String)"0"));
        version1 = Version.version((String)"255.254.253.252");
        version2 = Version.fromInt((int)version1.toInt());
        Assert.assertEquals((Object)version2, (Object)Version.version((int)255, (int)254, (String)"253", (String)"252"));
        Assert.assertTrue((Version.version((String)"0.0.2").toInt() > Version.version((String)"0.0.1").toInt() ? 1 : 0) != 0);
        Assert.assertTrue((Version.version((String)"0.1.0").toInt() > Version.version((String)"0.0.1").toInt() ? 1 : 0) != 0);
        Assert.assertTrue((Version.version((String)"1.0.0").toInt() > Version.version((String)"0.1.0").toInt() ? 1 : 0) != 0);
        Assert.assertTrue((Version.version((String)"1.1.0").toInt() > Version.version((String)"1.0.1").toInt() ? 1 : 0) != 0);
        Assert.assertTrue((Version.version((String)"2.1.1").toInt() > Version.version((String)"1.10.10").toInt() ? 1 : 0) != 0);
        Assert.assertTrue((Version.version((String)"0.1.0-rc2").toInt() > Version.version((String)"0.1.0-rc1").toInt() ? 1 : 0) != 0);
    }

    @Test
    public void testOrder() {
        List<Version> versions = Arrays.asList(Version.version((String)"0.1.0"), Version.version((String)"1.0.1"), Version.version((String)"0.0.1"), Version.version((String)"1.0.0"), Version.version((String)"1.1.1"));
        Collections.sort(versions);
        Assert.assertEquals(versions, Arrays.asList(Version.version((String)"0.0.1"), Version.version((String)"0.1.0"), Version.version((String)"1.0.0"), Version.version((String)"1.0.1"), Version.version((String)"1.1.1")));
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{Version.version((String)"1.2.3.4321"), Version.version((int)1, (int)2, (String)"3", (String)"4321")}).addEqualityGroup(new Object[]{Version.version((String)"1.9.3.4321"), Version.version((int)1, (int)9, (String)"3", (String)"4321")}).addEqualityGroup(new Object[]{Version.version((String)"1.2.8.4321"), Version.version((int)1, (int)2, (String)"8", (String)"4321")}).addEqualityGroup(new Object[]{Version.version((String)"1.2.3.x"), Version.version((int)1, (int)2, (String)"3", (String)"x")}).testEquals();
    }
}

