/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.collect.ImmutableSet;
import com.google.common.testing.EqualsTester;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterMetadata;
import org.onosproject.cluster.ClusterMetadataEvent;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.PartitionId;

public class ClusterMetadataEventTest {
    private final long time1 = System.currentTimeMillis() - 100L;
    private final long time = System.currentTimeMillis();
    private final PartitionId pid1 = PartitionId.from((int)1);
    private final PartitionId pid2 = PartitionId.from((int)2);
    private final NodeId nid1 = NodeId.nodeId((String)"10.0.0.1");
    private final NodeId nid2 = NodeId.nodeId((String)"10.0.0.2");
    private final ControllerNode n1 = new DefaultControllerNode(this.nid1, IpAddress.valueOf((String)"10.0.0.1"), 9876);
    private final ControllerNode n2 = new DefaultControllerNode(this.nid2, IpAddress.valueOf((String)"10.0.0.2"), 9876);
    private final ClusterMetadata metadata1 = new ClusterMetadata("foo", this.n1, (Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)this.n1), "test");
    private final ClusterMetadata metadata2 = new ClusterMetadata("bar", this.n1, (Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)this.n1, (Object)this.n2), "test");
    private final ClusterMetadata metadata3 = new ClusterMetadata("baz", this.n1, (Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)this.n2), "test");
    private final ClusterMetadataEvent event1 = new ClusterMetadataEvent(ClusterMetadataEvent.Type.METADATA_CHANGED, this.metadata1, this.time1);
    private final ClusterMetadataEvent sameAsEvent1 = new ClusterMetadataEvent(ClusterMetadataEvent.Type.METADATA_CHANGED, this.metadata1, this.time1);
    private final ClusterMetadataEvent event2 = new ClusterMetadataEvent(ClusterMetadataEvent.Type.METADATA_CHANGED, this.metadata2, this.time);
    private final ClusterMetadataEvent sameAsEvent2 = new ClusterMetadataEvent(ClusterMetadataEvent.Type.METADATA_CHANGED, this.metadata2, this.time);

    @Test
    public void checkEquals() throws Exception {
        Thread.sleep(1L);
        ClusterMetadataEvent event3 = new ClusterMetadataEvent(ClusterMetadataEvent.Type.METADATA_CHANGED, this.metadata3);
        new EqualsTester().addEqualityGroup(new Object[]{this.event1, this.sameAsEvent1}).addEqualityGroup(new Object[]{this.event2, this.sameAsEvent2}).addEqualityGroup(new Object[]{event3}).testEquals();
    }

    @Test
    public void checkConstruction() {
        Assert.assertThat((Object)((ClusterMetadataEvent.Type)this.event1.type()), (Matcher)Matchers.is((Object)ClusterMetadataEvent.Type.METADATA_CHANGED));
        Assert.assertThat((Object)((ClusterMetadata)this.event1.subject()), (Matcher)Matchers.is((Object)this.metadata1));
        Assert.assertThat((Object)this.event2.time(), (Matcher)Matchers.is((Object)this.time));
        Assert.assertThat((Object)((ClusterMetadataEvent.Type)this.event2.type()), (Matcher)Matchers.is((Object)ClusterMetadataEvent.Type.METADATA_CHANGED));
        Assert.assertThat((Object)((ClusterMetadata)this.event2.subject()), (Matcher)Matchers.is((Object)this.metadata2));
    }
}

