/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.junit.TestTools;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.SetEvent;
import org.onosproject.store.service.SetEventListener;
import org.onosproject.store.service.TestDistributedSet;

public class DistributedSetTest {
    protected InternalSetListener listener = new InternalSetListener();
    private static final String SETNAME = "set1";
    private TestDistributedSet<String> set1;
    private Set<String> set2;

    @Before
    public void setup() {
        this.set1 = new TestDistributedSet(SETNAME);
        this.set2 = new HashSet<String>();
        this.set1.addListener(this.listener);
    }

    @After
    public void teardown() {
        this.set1.removeListener(this.listener);
    }

    @Test
    public void basicTests() {
        this.set1.add("item1");
        Assert.assertEquals((String)"The set name should match.", (Object)SETNAME, (Object)this.set1.name());
        Assert.assertEquals((String)"The set primitive type should match.", (Object)DistributedPrimitive.Type.SET, (Object)this.set1.primitiveType());
        this.set1.add("item2");
        this.set1.add("item3");
        Assert.assertTrue((String)"set1 should contain 3 items", (this.set1.asDistributedSet().size() == 3 ? 1 : 0) != 0);
        this.set1.remove("item1");
        this.set1.remove("item2");
        this.set1.remove("item3");
        Assert.assertTrue((String)"set1 should be empty.", (boolean)this.set1.asDistributedSet(0L).isEmpty());
        this.validateEvents(new Enum[]{SetEvent.Type.ADD, SetEvent.Type.ADD, SetEvent.Type.ADD, SetEvent.Type.REMOVE, SetEvent.Type.REMOVE, SetEvent.Type.REMOVE});
    }

    @Test
    public void testClear() {
        this.set1.add("item1");
        this.set1.add("item2");
        this.set1.add("item3");
        this.set1.clear();
        Assert.assertTrue((String)"set1 should be empty.", (boolean)this.set1.asDistributedSet().isEmpty());
        this.validateEvents(new Enum[]{SetEvent.Type.ADD, SetEvent.Type.ADD, SetEvent.Type.ADD, SetEvent.Type.REMOVE, SetEvent.Type.REMOVE, SetEvent.Type.REMOVE});
    }

    @Test
    public void testAddAll() {
        this.set2.add("item1");
        this.set2.add("item2");
        this.set2.add("item3");
        this.set1.addAll(this.set2);
        Assert.assertTrue((String)"set1 should contain 3 items.", (this.set1.asDistributedSet().size() == this.set2.size() ? 1 : 0) != 0);
        this.validateEvents(new Enum[]{SetEvent.Type.ADD, SetEvent.Type.ADD, SetEvent.Type.ADD});
    }

    @Test
    public void testRemoveAll() {
        this.set1.add("item1");
        this.set1.add("item2");
        this.set1.add("item3");
        this.set2.add("item1");
        this.set1.removeAll(this.set2);
        Assert.assertTrue((String)"set1 should contain 2 items.", (this.set1.asDistributedSet().size() == 2 ? 1 : 0) != 0);
        this.validateEvents(new Enum[]{SetEvent.Type.ADD, SetEvent.Type.ADD, SetEvent.Type.ADD, SetEvent.Type.REMOVE});
    }

    @Test
    public void testRetainAll() {
        this.set1.add("item1");
        this.set1.add("item2");
        this.set1.add("item3");
        this.set2.add("item4");
        this.set1.retainAll(this.set2);
        Assert.assertTrue((String)"set1 should be empty.", (boolean)this.set1.asDistributedSet().isEmpty());
        this.validateEvents(new Enum[]{SetEvent.Type.ADD, SetEvent.Type.ADD, SetEvent.Type.ADD, SetEvent.Type.REMOVE, SetEvent.Type.REMOVE, SetEvent.Type.REMOVE});
        this.set1.add("item1");
        this.set1.add("item2");
        this.set1.add("item3");
        this.set2.add("item1");
        this.set1.retainAll(this.set2);
        Assert.assertTrue((String)"set1 size should be 1.", (this.set1.asDistributedSet().size() == 1 ? 1 : 0) != 0);
        this.validateEvents(new Enum[]{SetEvent.Type.ADD, SetEvent.Type.ADD, SetEvent.Type.ADD, SetEvent.Type.REMOVE, SetEvent.Type.REMOVE});
    }

    @Test
    public void testContains() {
        this.set1.add("item1");
        this.set1.add("item2");
        this.set1.add("item3");
        Assert.assertTrue((String)"set1 should contain item3.", (boolean)this.set1.asDistributedSet().contains((Object)"item3"));
    }

    @Test
    public void testContainsAll() {
        this.set1.add("item1");
        this.set1.add("item2");
        this.set1.add("item3");
        this.set2.add("item2");
        this.set2.add("item3");
        Assert.assertTrue((String)"set1 should contain all of set2.", (boolean)this.set1.asDistributedSet().containsAll(this.set2));
    }

    @Test
    public void testGetAsImmutableSet() {
        this.set1.add("item1");
        this.set1.add("item2");
        this.set1.add("item3");
        try {
            Assert.assertEquals((String)"set1 size should be 3.", (long)this.set1.getAsImmutableSet().get().size(), (long)this.set1.asDistributedSet().size());
        }
        catch (Exception e) {
            Assert.fail((String)("Expected exception. " + e.getMessage()));
        }
    }

    private void validateEvents(Enum ... types) {
        TestTools.assertAfter((int)100, () -> {
            int i = 0;
            Assert.assertEquals((String)"wrong events received", (long)types.length, (long)this.listener.events.size());
            for (SetEvent event : this.listener.events) {
                Assert.assertEquals((String)"incorrect event type", (Object)types[i], (Object)event.type());
                ++i;
            }
            this.listener.events.clear();
        });
    }

    private class InternalSetListener
    implements SetEventListener<String> {
        protected List<SetEvent> events = Lists.newArrayList();

        private InternalSetListener() {
        }

        public void event(SetEvent event) {
            this.events.add(event);
        }
    }
}

