/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.model.topo;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.ChassisId;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultEdgeLink;
import org.onosproject.net.DefaultHost;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.EdgeLink;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.region.DefaultRegion;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.model.AbstractUiModelTest;
import org.onosproject.ui.model.topo.UiClusterMember;
import org.onosproject.ui.model.topo.UiDevice;
import org.onosproject.ui.model.topo.UiDeviceLink;
import org.onosproject.ui.model.topo.UiEdgeLink;
import org.onosproject.ui.model.topo.UiHost;
import org.onosproject.ui.model.topo.UiLink;
import org.onosproject.ui.model.topo.UiLinkId;
import org.onosproject.ui.model.topo.UiRegion;
import org.onosproject.ui.model.topo.UiSynthLink;
import org.onosproject.ui.model.topo.UiTopology;

public class UiTopologyTest
extends AbstractUiModelTest {
    private static final DeviceId DEV_X = DeviceId.deviceId((String)"dev-X");
    private static final DeviceId DEV_Y = DeviceId.deviceId((String)"dev-Y");
    private static final PortNumber P1 = PortNumber.portNumber((long)1L);
    private static final PortNumber P2 = PortNumber.portNumber((long)2L);
    private static final String DEV_X_ID = "dev-x/1";
    private static final String DEV_Y_ID = "dev-y/2";
    private static final ConnectPoint CP_X1 = new ConnectPoint((ElementId)DEV_X, P1);
    private static final ConnectPoint CP_Y2 = new ConnectPoint((ElementId)DEV_Y, P2);
    private static final Link LINK_X1_TO_Y2 = DefaultLink.builder().providerId(ProviderId.NONE).src(CP_X1).dst(CP_Y2).type(Link.Type.DIRECT).build();
    private static final UiLinkId DX1_DY2 = UiLinkId.uiLinkId((Link)LINK_X1_TO_Y2);
    private static final RegionId ROOT = UiRegion.NULL_ID;
    private static final RegionId R1 = RegionId.regionId((String)"R1");
    private static final RegionId R2 = RegionId.regionId((String)"R2");
    private static final RegionId R3 = RegionId.regionId((String)"R3");
    private static final String DEV_LINK_CLASS = "UiDeviceLink";
    private static final String REG_LINK_CLASS = "UiRegionLink";
    private static final String REG_DEV_LINK_CLASS = "UiRegionDeviceLink";
    private Host host;
    private UiHost uiHost;
    private UiDeviceLink deviceLink;
    private EdgeLink edgeLink;
    private UiEdgeLink uiEdgeLink;
    private UiClusterMember mem1;
    private UiRegion region1;
    private UiDevice dev1;
    private UiLinkId linkId;
    private static final ProviderId PID = new ProviderId("of", "bar");
    private static final VlanId VID = VlanId.vlanId((short)20);
    private static final MacAddress MAC_ADDRESS = MacAddress.valueOf((String)"00:11:00:00:00:01");
    private static final HostId HID = HostId.hostId((MacAddress)MAC_ADDRESS, (VlanId)VID);
    private static final DeviceId DID = DeviceId.deviceId((String)"of:foo");
    private static final HostLocation LOC = new HostLocation(DID, PortNumber.portNumber((long)8L), 123L);
    private static final ConnectPoint CP = new ConnectPoint((ElementId)DEV_X, PortNumber.portNumber((long)8L));
    private static final Set<IpAddress> IPSET = Sets.newHashSet((Object[])new IpAddress[]{IpAddress.valueOf((String)"10.0.0.1"), IpAddress.valueOf((String)"10.0.0.2")});
    private static final String MID = "id1";
    private UiTopology topo;
    private UiDeviceLink devLink;
    private List<RegionId> xBranch;
    private List<RegionId> yBranch;
    private UiSynthLink synth;

    @Before
    public void setUp() {
        this.topo = new UiTopology(MOCK_SERVICES);
        this.devLink = new UiDeviceLink(null, DX1_DY2);
        this.devLink.attachBackingLink(LINK_X1_TO_Y2);
    }

    @Test
    public void basic() {
        UiTopologyTest.title("basic");
        UiTopologyTest.print(this.topo);
    }

    private List<RegionId> branch(RegionId ... ids) {
        ArrayList<RegionId> result = new ArrayList<RegionId>(ids.length);
        Collections.addAll(result, ids);
        return result;
    }

    private void verifySynth(RegionId id, String cls, String epA, String epB) {
        this.synth = this.topo.makeSynthLink(this.devLink, this.xBranch, this.yBranch);
        UiLink ulink = this.synth.link();
        UiTopologyTest.print(this.synth);
        UiTopologyTest.print("EpA{%s}  EpB{%s}", ulink.endPointA(), ulink.endPointB());
        Assert.assertEquals((String)"wrong region", (Object)id, (Object)this.synth.regionId());
        Assert.assertEquals((String)"wrong link class", (Object)cls, (Object)ulink.type());
        Assert.assertEquals((String)"wrong EP A", (Object)epA, (Object)ulink.endPointA());
        Assert.assertEquals((String)"wrong EP B", (Object)epB, (Object)ulink.endPointB());
    }

    @Test
    public void makeSynthDevToDevRoot() {
        UiTopologyTest.title("makeSynthDevToDevRoot");
        this.xBranch = this.branch(ROOT);
        this.yBranch = this.branch(ROOT);
        this.verifySynth(ROOT, DEV_LINK_CLASS, DEV_X_ID, DEV_Y_ID);
    }

    @Test
    public void makeSynthDevToDevR1() {
        UiTopologyTest.title("makeSynthDevToDevR1");
        this.xBranch = this.branch(ROOT, R1);
        this.yBranch = this.branch(ROOT, R1);
        this.verifySynth(R1, DEV_LINK_CLASS, DEV_X_ID, DEV_Y_ID);
    }

    @Test
    public void makeSynthDevToDevR2() {
        UiTopologyTest.title("makeSynthDevToDevR2");
        this.xBranch = this.branch(ROOT, R1, R2);
        this.yBranch = this.branch(ROOT, R1, R2);
        this.verifySynth(R2, DEV_LINK_CLASS, DEV_X_ID, DEV_Y_ID);
    }

    @Test
    public void makeSynthRegToRegRoot() {
        UiTopologyTest.title("makeSynthRegToRegRoot");
        this.xBranch = this.branch(ROOT, R1);
        this.yBranch = this.branch(ROOT, R2);
        this.verifySynth(ROOT, REG_LINK_CLASS, (String)R1.id(), (String)R2.id());
    }

    @Test
    public void makeSynthRegToRegR1() {
        UiTopologyTest.title("makeSynthRegToRegR1");
        this.xBranch = this.branch(ROOT, R1, R2);
        this.yBranch = this.branch(ROOT, R1, R3);
        this.verifySynth(R1, REG_LINK_CLASS, (String)R2.id(), (String)R3.id());
    }

    @Test
    public void makeSynthRegToDevRoot() {
        UiTopologyTest.title("makeSynthRegToDevRoot");
        this.xBranch = this.branch(ROOT);
        this.yBranch = this.branch(ROOT, R1);
        this.verifySynth(ROOT, REG_DEV_LINK_CLASS, (String)R1.id(), DEV_X_ID);
        this.xBranch = this.branch(ROOT, R1);
        this.yBranch = this.branch(ROOT);
        this.verifySynth(ROOT, REG_DEV_LINK_CLASS, (String)R1.id(), DEV_Y_ID);
    }

    @Test
    public void makeSynthRegToDevR3() {
        UiTopologyTest.title("makeSynthRegToDevR3");
        this.xBranch = this.branch(ROOT, R3);
        this.yBranch = this.branch(ROOT, R3, R1);
        this.verifySynth(R3, REG_DEV_LINK_CLASS, (String)R1.id(), DEV_X_ID);
        this.xBranch = this.branch(ROOT, R3, R1);
        this.yBranch = this.branch(ROOT, R3);
        this.verifySynth(R3, REG_DEV_LINK_CLASS, (String)R1.id(), DEV_Y_ID);
    }

    @Test
    public void mockTopology() {
        this.host = new DefaultHost(PID, HID, MAC_ADDRESS, VID, LOC, IPSET, new Annotations[0]);
        this.uiHost = new UiHost(this.topo, this.host);
        this.deviceLink = new UiDeviceLink(this.topo, DX1_DY2);
        this.edgeLink = DefaultEdgeLink.createEdgeLink((ConnectPoint)CP, (boolean)true);
        this.linkId = UiLinkId.uiLinkId((Link)this.edgeLink);
        this.uiEdgeLink = new UiEdgeLink(this.topo, this.linkId);
        this.mem1 = this.clusterMember(MID, 1);
        this.region1 = this.region();
        this.dev1 = this.device();
        HashSet<DeviceId> deviceIds = new HashSet<DeviceId>();
        HashSet<HostId> hostIds = new HashSet<HostId>();
        this.topo.add(this.uiHost);
        this.topo.add(this.mem1);
        this.topo.add(this.region1);
        this.topo.add(this.dev1);
        this.topo.add(this.deviceLink);
        this.topo.add(this.uiEdgeLink);
        Assert.assertTrue((boolean)this.topo.allRegions().contains(this.region1));
        Assert.assertTrue((boolean)this.topo.allClusterMembers().contains(this.mem1));
        Assert.assertTrue((boolean)this.topo.findClusterMember(NodeId.nodeId((String)MID)).equals(this.mem1));
        Assert.assertTrue((boolean)this.topo.findRegion(R1).equals(this.region1));
        Assert.assertTrue((boolean)this.topo.findDevice(DID).equals(this.dev1));
        Assert.assertTrue((boolean)this.topo.findHost(HID).equals(this.uiHost));
        Assert.assertTrue((boolean)this.topo.findDeviceLink(DX1_DY2).equals(this.deviceLink));
        deviceIds.add(DID);
        Assert.assertTrue((boolean)this.topo.deviceSet(deviceIds).contains(this.dev1));
        hostIds.add(HID);
        Assert.assertTrue((boolean)this.topo.hostSet(hostIds).contains(this.uiHost));
        this.topo.clear();
        Assert.assertThat((Object)this.topo.allClusterMembers(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)this.topo.allDeviceLinks(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)this.topo.allDevices(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)this.topo.allHosts(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)this.topo.allRegions(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    private UiClusterMember clusterMember(String nodeId, int ipAddress) {
        return new UiClusterMember(this.topo, (ControllerNode)new DefaultControllerNode(NodeId.nodeId((String)nodeId), IpAddress.valueOf((int)ipAddress)));
    }

    private UiRegion region() {
        return new UiRegion(this.topo, (Region)new DefaultRegion(R1, "reg1", Region.Type.METRO, (Annotations)DefaultAnnotations.EMPTY, null));
    }

    private UiDevice device() {
        return new UiDevice(this.topo, (Device)new DefaultDevice(PID, DID, Device.Type.SWITCH, "whitebox", "1.1.x", "3.9.1", "43331", new ChassisId(), new Annotations[0]));
    }
}

