/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour;

import java.util.Map;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.Identifier;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.driver.HandlerBehaviour;
import org.onosproject.net.pi.runtime.PiCounterCellData;

public interface BngProgrammable
extends HandlerBehaviour {
    public boolean init(ApplicationId var1);

    public void cleanUp(ApplicationId var1) throws BngProgrammableException;

    public void setupAttachment(Attachment var1) throws BngProgrammableException;

    public void removeAttachment(Attachment var1);

    public Map<BngCounterType, PiCounterCellData> readCounters(Attachment var1) throws BngProgrammableException;

    public PiCounterCellData readCounter(Attachment var1, BngCounterType var2) throws BngProgrammableException;

    public PiCounterCellData readControlTrafficCounter() throws BngProgrammableException;

    public void resetCounter(Attachment var1, BngCounterType var2) throws BngProgrammableException;

    public void resetCounters(Attachment var1) throws BngProgrammableException;

    public void resetControlTrafficCounter() throws BngProgrammableException;

    public static class BngProgrammableException
    extends Exception {
        public BngProgrammableException(String message) {
            super(message);
        }
    }

    public static class AttachmentId
    extends Identifier<Long> {
        public AttachmentId(long id) {
            super((Object)id);
        }
    }

    public static interface Attachment {
        public AttachmentId attachmentId();

        public ApplicationId appId();

        public VlanId sTag();

        public VlanId cTag();

        public MacAddress macAddress();

        public IpAddress ipAddress();

        public boolean lineActive();

        public AttachmentType type();

        public short pppoeSessionId();

        public static enum AttachmentType {
            PPPoE,
            IPoE;

        }
    }

    public static enum BngCounterType {
        DOWNSTREAM_RX,
        DOWNSTREAM_TX,
        DOWNSTREAM_DROPPED,
        UPSTREAM_RX,
        UPSTREAM_TX,
        UPSTREAM_DROPPED,
        CONTROL_PLANE;

    }
}

