/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.link;

import org.junit.Test;
import org.onosproject.event.AbstractEventTest;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.provider.ProviderId;

public class LinkEventTest
extends AbstractEventTest {
    private Link createLink() {
        return DefaultLink.builder().providerId(new ProviderId("of", "foo")).src(new ConnectPoint((ElementId)DeviceId.deviceId((String)"of:foo"), PortNumber.portNumber((long)1L))).dst(new ConnectPoint((ElementId)DeviceId.deviceId((String)"of:bar"), PortNumber.portNumber((long)2L))).type(Link.Type.INDIRECT).build();
    }

    @Override
    @Test
    public void withTime() {
        Link link = this.createLink();
        LinkEvent event = new LinkEvent(LinkEvent.Type.LINK_ADDED, link, 123L);
        LinkEventTest.validateEvent(event, LinkEvent.Type.LINK_ADDED, link, 123L);
    }

    @Override
    @Test
    public void withoutTime() {
        Link link = this.createLink();
        long before = System.currentTimeMillis();
        LinkEvent event = new LinkEvent(LinkEvent.Type.LINK_ADDED, link);
        long after = System.currentTimeMillis();
        LinkEventTest.validateEvent(event, LinkEvent.Type.LINK_ADDED, link, before, after);
    }
}

