/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.packet;

import com.google.common.testing.EqualsTester;
import java.nio.ByteBuffer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.packet.Ethernet;
import org.onlab.packet.MacAddress;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.IntentTestsMocks;
import org.onosproject.net.packet.DefaultOutboundPacket;

public class DefaultOutboundPacketTest {
    final Ethernet eth = new Ethernet().setDestinationMACAddress(MacAddress.BROADCAST).setSourceMACAddress(MacAddress.BROADCAST);
    final ByteBuffer byteBuffer = ByteBuffer.wrap(this.eth.serialize());
    final TrafficTreatment treatment = new IntentTestsMocks.MockTreatment();
    final DefaultOutboundPacket packet1 = new DefaultOutboundPacket(NetTestTools.did("d1"), this.treatment, this.byteBuffer);
    final DefaultOutboundPacket sameAsPacket1 = new DefaultOutboundPacket(NetTestTools.did("d1"), this.treatment, this.byteBuffer);
    private final PortNumber inPort = PortNumber.portNumber((long)1L);
    final DefaultOutboundPacket packet1WithInPort = new DefaultOutboundPacket(NetTestTools.did("d1"), this.treatment, this.byteBuffer, this.inPort);
    final DefaultOutboundPacket packet2 = new DefaultOutboundPacket(NetTestTools.did("d2"), this.treatment, this.byteBuffer);

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(DefaultOutboundPacket.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.packet1, this.sameAsPacket1}).addEqualityGroup(new Object[]{this.packet2}).addEqualityGroup(new Object[]{this.packet1WithInPort}).testEquals();
    }

    @Test
    public void testConstruction() {
        MatcherAssert.assertThat((Object)this.packet1.sendThrough(), (Matcher)Matchers.equalTo((Object)NetTestTools.did("d1")));
        MatcherAssert.assertThat((Object)this.packet1.data(), (Matcher)Matchers.equalTo((Object)this.byteBuffer));
        MatcherAssert.assertThat((Object)this.packet1.treatment(), (Matcher)Matchers.equalTo((Object)this.treatment));
        MatcherAssert.assertThat((Object)this.packet1.inPort(), (Matcher)Matchers.equalTo(null));
        MatcherAssert.assertThat((Object)this.packet1WithInPort.inPort(), (Matcher)Matchers.equalTo((Object)this.inPort));
    }
}

