/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.packet;

import com.google.common.testing.EqualsTester;
import java.nio.ByteBuffer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.packet.Ethernet;
import org.onlab.packet.MacAddress;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.IntentTestsMocks;
import org.onosproject.net.packet.DefaultInboundPacket;
import org.onosproject.net.packet.DefaultOutboundPacket;
import org.onosproject.net.packet.DefaultPacketContext;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketContextAdapter;

public class DefaultPacketContextTest {
    final Ethernet eth = new Ethernet().setDestinationMACAddress(MacAddress.BROADCAST).setSourceMACAddress(MacAddress.BROADCAST);
    final ByteBuffer byteBuffer = ByteBuffer.wrap(this.eth.serialize());
    final DefaultInboundPacket inPacket = new DefaultInboundPacket(NetTestTools.connectPoint("d1", 1), this.eth, this.byteBuffer);
    final TrafficTreatment treatment = new IntentTestsMocks.MockTreatment();
    final DefaultOutboundPacket outPacket = new DefaultOutboundPacket(NetTestTools.did("d1"), this.treatment, this.byteBuffer);
    final DefaultPacketContext context1 = new PacketContextAdapter(123L, (InboundPacket)this.inPacket, (OutboundPacket)this.outPacket, true);
    final DefaultPacketContext sameAsContext1 = new PacketContextAdapter(123L, (InboundPacket)this.inPacket, (OutboundPacket)this.outPacket, true);
    final DefaultPacketContext context2 = new PacketContextAdapter(123123L, (InboundPacket)this.inPacket, (OutboundPacket)this.outPacket, true);

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutableBaseClass(DefaultPacketContext.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.context1}).addEqualityGroup(new Object[]{this.sameAsContext1}).addEqualityGroup(new Object[]{this.context2}).testEquals();
    }

    @Test
    public void testConstruction() {
        MatcherAssert.assertThat((Object)this.context1.block(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.context1.inPacket(), (Matcher)Matchers.is((Object)this.inPacket));
        MatcherAssert.assertThat((Object)this.context1.isHandled(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.context1.outPacket(), (Matcher)Matchers.is((Object)this.outPacket));
        MatcherAssert.assertThat((Object)this.context1.time(), (Matcher)Matchers.is((Object)123L));
        MatcherAssert.assertThat((Object)this.context1.treatmentBuilder(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

