/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiActionId;
import org.onosproject.net.pi.model.PiActionParamId;
import org.onosproject.net.pi.model.PiActionProfileId;
import org.onosproject.net.pi.runtime.PiAction;
import org.onosproject.net.pi.runtime.PiActionParam;
import org.onosproject.net.pi.runtime.PiActionProfileGroup;
import org.onosproject.net.pi.runtime.PiActionProfileGroupId;
import org.onosproject.net.pi.runtime.PiActionProfileMember;
import org.onosproject.net.pi.runtime.PiActionProfileMemberId;

public class PiActionProfileGroupTest {
    private final PiActionProfileId actionProfileId1 = PiActionProfileId.of((String)"foo");
    private final PiActionProfileId actionProfileId2 = PiActionProfileId.of((String)"bar");
    private final PiActionProfileGroupId groupId1 = PiActionProfileGroupId.of((int)100);
    private final PiActionProfileGroupId groupId2 = PiActionProfileGroupId.of((int)200);
    private final PiActionProfileMemberId actProfMemberId1 = PiActionProfileMemberId.of((int)10);
    private final PiActionProfileMemberId actProfMemberId2 = PiActionProfileMemberId.of((int)20);
    private final PiAction piAction1 = PiAction.builder().withId(PiActionId.of((String)"mod_nw_dst")).withParameter(new PiActionParam(PiActionParamId.of((String)"dstAddr"), ImmutableByteSequence.copyFrom((int)0xA010101))).build();
    private final PiAction piAction2 = PiAction.builder().withId(PiActionId.of((String)"mod_vlan_vid")).withParameter(new PiActionParam(PiActionParamId.of((String)"vid"), ImmutableByteSequence.copyFrom((int)11))).build();
    private final PiActionProfileMember actProfMember11 = PiActionProfileMember.builder().forActionProfile(this.actionProfileId1).withId(this.actProfMemberId1).withAction(this.piAction1).build();
    private final PiActionProfileMember actProfMember12 = PiActionProfileMember.builder().forActionProfile(this.actionProfileId1).withId(this.actProfMemberId2).withAction(this.piAction2).build();
    private final PiActionProfileMember actProfMember21 = PiActionProfileMember.builder().forActionProfile(this.actionProfileId2).withId(this.actProfMemberId1).withAction(this.piAction1).build();
    private final PiActionProfileMember actProfMember22 = PiActionProfileMember.builder().forActionProfile(this.actionProfileId2).withId(this.actProfMemberId2).withAction(this.piAction2).build();
    private final PiActionProfileGroup.WeightedMember weightedMember1 = new PiActionProfileGroup.WeightedMember(this.actProfMemberId1, 1);
    private final PiActionProfileGroup.WeightedMember weightedMember2 = new PiActionProfileGroup.WeightedMember(this.actProfMemberId2, 1);
    private PiActionProfileGroup group1 = PiActionProfileGroup.builder().withActionProfileId(this.actionProfileId1).addMember(this.actProfMember11).addMember(this.actProfMember12).withId(this.groupId1).build();
    private PiActionProfileGroup sameAsGroup1 = PiActionProfileGroup.builder().withActionProfileId(this.actionProfileId1).addMember(this.actProfMember12).addMember(this.actProfMember11).withId(this.groupId1).build();
    private PiActionProfileGroup sameAsGroup1NoInstance = PiActionProfileGroup.builder().withActionProfileId(this.actionProfileId1).addMember(this.weightedMember1).addMember(this.weightedMember2).withId(this.groupId1).build();
    private PiActionProfileGroup group2 = PiActionProfileGroup.builder().withActionProfileId(this.actionProfileId2).addMember(this.actProfMember21).addMember(this.actProfMember22).withId(this.groupId2).build();
    private PiActionProfileGroup sameAsGroup2NoInstance = PiActionProfileGroup.builder().withActionProfileId(this.actionProfileId2).addMember(this.actProfMemberId1).addMember(this.actProfMemberId2).withId(this.groupId2).build();
    private PiActionProfileGroup asGroup2WithDifferentWeights = PiActionProfileGroup.builder().withActionProfileId(this.actionProfileId2).addMember(this.actProfMemberId1, 100).addMember(this.actProfMemberId2, 100).withId(this.groupId2).build();

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PiActionProfileGroup.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.group1, this.sameAsGroup1, this.sameAsGroup1NoInstance}).addEqualityGroup(new Object[]{this.group2, this.sameAsGroup2NoInstance}).addEqualityGroup(new Object[]{this.asGroup2WithDifferentWeights}).testEquals();
    }

    @Test
    public void testMethods() {
        MatcherAssert.assertThat((Object)this.group1, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.group1.id(), (Matcher)Matchers.is((Object)this.groupId1));
        MatcherAssert.assertThat((Object)this.group1.actionProfile(), (Matcher)Matchers.is((Object)this.actionProfileId1));
        MatcherAssert.assertThat((Object)this.group1.members().size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)this.group1.members().contains(this.weightedMember1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.group1.members().contains(this.weightedMember2), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.group1.member(this.actProfMemberId1).isPresent(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.group1.member(this.actProfMemberId2).isPresent(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)((PiActionProfileGroup.WeightedMember)this.group1.member(this.actProfMemberId1).get()).instance(), (Matcher)Matchers.is((Object)this.actProfMember11));
        MatcherAssert.assertThat((Object)((PiActionProfileGroup.WeightedMember)this.group1.member(this.actProfMemberId2).get()).instance(), (Matcher)Matchers.is((Object)this.actProfMember12));
        MatcherAssert.assertThat((Object)this.sameAsGroup2NoInstance.member(this.actProfMemberId1).isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.sameAsGroup2NoInstance.member(this.actProfMemberId2).isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((PiActionProfileGroup.WeightedMember)this.sameAsGroup2NoInstance.member(this.actProfMemberId1).get()).instance(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)((PiActionProfileGroup.WeightedMember)this.sameAsGroup2NoInstance.member(this.actProfMemberId2).get()).instance(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }
}

