/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;

public class DefaultControllerNode
implements ControllerNode {
    public static final int DEFAULT_PORT = 9876;
    private final NodeId id;
    private final String host;
    private final int tcpPort;
    private volatile transient IpAddress ip;

    private DefaultControllerNode() {
        this.id = null;
        this.host = null;
        this.tcpPort = 0;
    }

    public DefaultControllerNode(NodeId id, String host) {
        this(id, host, 9876);
    }

    public DefaultControllerNode(NodeId id, String host, int tcpPort) {
        this.id = (NodeId)Preconditions.checkNotNull((Object)id);
        this.host = host;
        this.tcpPort = tcpPort;
    }

    public DefaultControllerNode(NodeId id, IpAddress ip) {
        this(id, ip != null ? ip.toString() : null, 9876);
    }

    public DefaultControllerNode(NodeId id, IpAddress ip, int tcpPort) {
        this(id, ip != null ? ip.toString() : null, tcpPort);
    }

    @Override
    public NodeId id() {
        return this.id;
    }

    @Override
    public String host() {
        return this.host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IpAddress ip(boolean resolve) {
        if (resolve) {
            this.ip = this.resolveIp();
            return this.ip;
        }
        if (this.ip == null) {
            DefaultControllerNode defaultControllerNode = this;
            synchronized (defaultControllerNode) {
                if (this.ip == null) {
                    this.ip = this.resolveIp();
                }
            }
        }
        return this.ip;
    }

    private IpAddress resolveIp() {
        try {
            return IpAddress.valueOf((InetAddress)InetAddress.getByName(this.host));
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    public int tcpPort() {
        return this.tcpPort;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DefaultControllerNode) {
            DefaultControllerNode that = (DefaultControllerNode)o;
            return Objects.equals(this.id, that.id);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("host", (Object)this.host).add("tcpPort", this.tcpPort).toString();
    }
}

