/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import com.google.common.collect.ImmutableSet;
import com.google.common.testing.EqualsTester;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.cluster.DefaultPartition;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.Partition;
import org.onosproject.cluster.PartitionId;
import org.onosproject.store.primitives.PartitionEvent;

public class PartitionEventTest {
    private final long time = System.currentTimeMillis();
    private final long time0 = 0L;
    private final PartitionId pid1 = PartitionId.from((int)1);
    private final PartitionId pid2 = PartitionId.from((int)2);
    private final NodeId nid1 = NodeId.nodeId((String)"10.0.0.1");
    private final NodeId nid2 = NodeId.nodeId((String)"10.0.0.2");
    private final Partition p1 = new DefaultPartition(this.pid1, (Collection)ImmutableSet.of((Object)this.nid1));
    private final Partition p2 = new DefaultPartition(this.pid2, (Collection)ImmutableSet.of((Object)this.nid1, (Object)this.nid2));
    private final PartitionEvent event1 = new PartitionEvent(PartitionEvent.Type.UPDATED, this.p1, this.time);
    private final PartitionEvent sameAsEvent1 = new PartitionEvent(PartitionEvent.Type.UPDATED, this.p1, this.time);
    private final PartitionEvent event2 = new PartitionEvent(PartitionEvent.Type.OPENED, this.p1, this.time);
    private final PartitionEvent event3 = new PartitionEvent(PartitionEvent.Type.CLOSED, this.p1, this.time);
    private final PartitionEvent event4 = new PartitionEvent(PartitionEvent.Type.AVAILABLE, this.p1, this.time);
    private final PartitionEvent event5 = new PartitionEvent(PartitionEvent.Type.UNAVAILABLE, this.p1, this.time);
    private final PartitionEvent event6 = new PartitionEvent(PartitionEvent.Type.UPDATED, this.p2, this.time);
    private final PartitionEvent event7 = new PartitionEvent(PartitionEvent.Type.UPDATED, this.p1, 0L);

    @Test
    public void checkEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.event1, this.sameAsEvent1}).addEqualityGroup(new Object[]{this.event2}).addEqualityGroup(new Object[]{this.event3}).addEqualityGroup(new Object[]{this.event4}).addEqualityGroup(new Object[]{this.event5}).addEqualityGroup(new Object[]{this.event6}).addEqualityGroup(new Object[]{this.event7}).testEquals();
    }

    @Test
    public void checkConstruction() {
        Assert.assertThat((Object)((PartitionEvent.Type)this.event1.type()), (Matcher)Matchers.is((Object)PartitionEvent.Type.UPDATED));
        Assert.assertThat((Object)((Partition)this.event1.subject()), (Matcher)Matchers.is((Object)this.p1));
        Assert.assertThat((Object)this.event1.time(), (Matcher)Matchers.is((Object)this.time));
    }
}

