/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class TestingCompletableFutures {
    private TestingCompletableFutures() {
    }

    public static CompletableFuture<Long> createFuture(ErrorState errorState) {
        switch (errorState) {
            case TIMEOUT_EXCEPTION: {
                return new TimeoutExceptionFuture<Long>();
            }
            case INTERRUPTED_EXCEPTION: {
                return new InterruptedFuture<Long>();
            }
            case EXECUTION_EXCEPTION: {
                return new ExecutionExceptionFuture<Long>();
            }
        }
        return new CompletableFuture<Long>();
    }

    public static CompletableFuture<String> createStringFuture(ErrorState errorState) {
        switch (errorState) {
            case TIMEOUT_EXCEPTION: {
                return new TimeoutExceptionFuture<String>();
            }
            case INTERRUPTED_EXCEPTION: {
                return new InterruptedFuture<String>();
            }
            case EXECUTION_EXCEPTION: {
                return new ExecutionExceptionFuture<String>();
            }
        }
        return new CompletableFuture<String>();
    }

    private static class ExecutionExceptionFuture<T>
    extends CompletableFuture<T> {
        private ExecutionExceptionFuture() {
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws ExecutionException {
            throw new ExecutionException("", new Exception());
        }
    }

    private static class InterruptedFuture<T>
    extends CompletableFuture<T> {
        private InterruptedFuture() {
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException {
            throw new InterruptedException();
        }
    }

    private static class TimeoutExceptionFuture<T>
    extends CompletableFuture<T> {
        private TimeoutExceptionFuture() {
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws TimeoutException {
            throw new TimeoutException();
        }
    }

    public static enum ErrorState {
        NONE,
        INTERRUPTED_EXCEPTION,
        TIMEOUT_EXCEPTION,
        EXECUTION_EXCEPTION;

    }
}

