/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiMatchFieldId;
import org.onosproject.net.pi.model.PiMatchType;
import org.onosproject.net.pi.runtime.PiFieldMatch;

@Beta
public final class PiTernaryFieldMatch
extends PiFieldMatch {
    private final ImmutableByteSequence value;
    private final ImmutableByteSequence mask;

    public PiTernaryFieldMatch(PiMatchFieldId fieldId, ImmutableByteSequence value, ImmutableByteSequence mask) {
        super(fieldId);
        this.value = (ImmutableByteSequence)Preconditions.checkNotNull((Object)value);
        this.mask = (ImmutableByteSequence)Preconditions.checkNotNull((Object)mask);
        Preconditions.checkArgument((value.size() == mask.size() && value.size() > 0 ? 1 : 0) != 0, (Object)"Value and mask must have same non-zero size");
    }

    public ImmutableByteSequence value() {
        return this.value;
    }

    public ImmutableByteSequence mask() {
        return this.mask;
    }

    @Override
    public PiMatchType type() {
        return PiMatchType.TERNARY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiTernaryFieldMatch that = (PiTernaryFieldMatch)o;
        return Objects.equal((Object)((Object)this.fieldId()), (Object)((Object)that.fieldId())) && Objects.equal((Object)this.value, (Object)that.value) && Objects.equal((Object)this.mask, (Object)that.mask);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fieldId(), this.value, this.mask});
    }

    public String toString() {
        return this.fieldId().toString() + "=" + this.value.toString() + "&&&" + this.mask.toString();
    }
}

