/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.protection;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.onosproject.net.behaviour.protection.ProtectedTransportEndpointDescription;
import org.onosproject.net.behaviour.protection.TransportEndpointState;

@Beta
@Immutable
public class ProtectedTransportEndpointState {
    public static final int ACTIVE_UNKNOWN = -1;
    private final List<TransportEndpointState> pathStates;
    private final int activePathIndex;
    private final ProtectedTransportEndpointDescription description;

    protected ProtectedTransportEndpointState(ProtectedTransportEndpointDescription description, List<TransportEndpointState> pathStates, int activePathIndex) {
        this.description = (ProtectedTransportEndpointDescription)Preconditions.checkNotNull((Object)description);
        this.pathStates = ImmutableList.copyOf(pathStates);
        this.activePathIndex = activePathIndex;
    }

    public ProtectedTransportEndpointDescription description() {
        return this.description;
    }

    public List<TransportEndpointState> pathStates() {
        return this.pathStates;
    }

    public int workingPathIndex() {
        return this.activePathIndex;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pathState", this.pathStates).add("activePathIndex", this.activePathIndex).add("description", (Object)this.description).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<TransportEndpointState> pathStates;
        private int activePathIndex = -1;
        private ProtectedTransportEndpointDescription description;

        public Builder copyFrom(ProtectedTransportEndpointState src) {
            this.pathStates = src.pathStates();
            this.activePathIndex = src.workingPathIndex();
            this.description = src.description();
            return this;
        }

        public Builder withPathStates(List<TransportEndpointState> pathStates) {
            this.pathStates = pathStates;
            return this;
        }

        public Builder withActivePathIndex(int activePathIndex) {
            this.activePathIndex = activePathIndex;
            return this;
        }

        public Builder withDescription(ProtectedTransportEndpointDescription description) {
            this.description = description;
            return this;
        }

        public ProtectedTransportEndpointState build() {
            Preconditions.checkNotNull((Object)this.description, (Object)"description field is mandatory");
            Preconditions.checkNotNull(this.pathStates, (Object)"pathStates field is mandatory");
            Preconditions.checkArgument((this.activePathIndex < this.pathStates.size() ? 1 : 0) != 0, (String)"Invalid active path index %s > %s", (int)this.activePathIndex, (int)this.pathStates.size());
            return new ProtectedTransportEndpointState(this.description, this.pathStates, this.activePathIndex);
        }
    }
}

