/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.onosproject.net.DeviceId;
import org.onosproject.net.pi.runtime.PiCloneSessionEntryHandle;
import org.onosproject.net.pi.runtime.PiEntityType;
import org.onosproject.net.pi.runtime.PiPreEntry;
import org.onosproject.net.pi.runtime.PiPreEntryType;
import org.onosproject.net.pi.runtime.PiPreReplica;

@Beta
public final class PiCloneSessionEntry
implements PiPreEntry {
    public static final int DEFAULT_CLASS_OF_SERVICE = 0;
    public static final int DO_NOT_TRUNCATE = 0;
    private final int sessionId;
    private final Set<PiPreReplica> replicas;
    private final int classOfService;
    private final int maxPacketLengthBytes;

    private PiCloneSessionEntry(int sessionId, Set<PiPreReplica> replicas, int classOfService, int maxPacketBytes) {
        this.sessionId = sessionId;
        this.replicas = replicas;
        this.classOfService = classOfService;
        this.maxPacketLengthBytes = maxPacketBytes;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public Set<PiPreReplica> replicas() {
        return this.replicas;
    }

    public int classOfService() {
        return this.classOfService;
    }

    public int maxPacketLengthBytes() {
        return this.maxPacketLengthBytes;
    }

    @Override
    public PiEntityType piEntityType() {
        return PiEntityType.PRE_ENTRY;
    }

    @Override
    public PiPreEntryType preEntryType() {
        return PiPreEntryType.CLONE_SESSION;
    }

    @Override
    public PiCloneSessionEntryHandle handle(DeviceId deviceId) {
        return PiCloneSessionEntryHandle.of(deviceId, this);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sessionId, this.replicas, this.classOfService, this.maxPacketLengthBytes});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PiCloneSessionEntry other = (PiCloneSessionEntry)obj;
        return Objects.equal((Object)this.sessionId, (Object)other.sessionId) && Objects.equal(this.replicas, other.replicas) && Objects.equal((Object)this.classOfService, (Object)other.classOfService) && Objects.equal((Object)this.maxPacketLengthBytes, (Object)other.maxPacketLengthBytes);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sessionId", this.sessionId).add("replicas", this.replicas).add("classOfService", this.classOfService).add("maxPacketLengthBytes", this.maxPacketLengthBytes).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer sessionId;
        private ImmutableSet.Builder<PiPreReplica> replicaSetBuilder = ImmutableSet.builder();
        private int classOfService = 0;
        private int maxPacketLengthBytes = 0;

        private Builder() {
        }

        public Builder withSessionId(int sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder addReplica(PiPreReplica replica) {
            Preconditions.checkNotNull((Object)replica);
            this.replicaSetBuilder.add((Object)replica);
            return this;
        }

        public Builder addReplicas(Collection<PiPreReplica> replicas) {
            Preconditions.checkNotNull(replicas);
            this.replicaSetBuilder.addAll(replicas);
            return this;
        }

        public Builder withClassOfService(int classOfService) {
            this.classOfService = classOfService;
            return this;
        }

        public Builder withMaxPacketLengthBytes(int maxPacketLengthBytes) {
            Preconditions.checkArgument((maxPacketLengthBytes >= 0 ? 1 : 0) != 0, (Object)"maxPacketLengthBytes must be a positive integer");
            this.maxPacketLengthBytes = maxPacketLengthBytes;
            return this;
        }

        public PiCloneSessionEntry build() {
            Preconditions.checkNotNull((Object)this.sessionId, (Object)"Clone session ID must be set");
            ImmutableSet replicas = this.replicaSetBuilder.build();
            return new PiCloneSessionEntry(this.sessionId, (Set<PiPreReplica>)replicas, this.classOfService, this.maxPacketLengthBytes);
        }
    }
}

