/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onosproject.net.pi.model.PiRegisterId;

@Beta
public final class PiRegisterCellId {
    private final PiRegisterId registerId;
    private final long index;

    private PiRegisterCellId(PiRegisterId registerId, long index) {
        this.registerId = registerId;
        this.index = index;
    }

    public PiRegisterId registerId() {
        return this.registerId;
    }

    public long index() {
        return this.index;
    }

    public static PiRegisterCellId of(PiRegisterId registerId, long index) {
        Preconditions.checkNotNull((Object)((Object)registerId));
        Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0, (Object)"Index must be a positive number");
        return new PiRegisterCellId(registerId, index);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PiRegisterCellId other = (PiRegisterCellId)obj;
        return Objects.equal((Object)((Object)this.registerId), (Object)((Object)other.registerId)) && Objects.equal((Object)this.index, (Object)other.index);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.registerId, this.index});
    }

    public String toString() {
        return this.registerId.toString() + ":" + String.valueOf(this.index);
    }
}

