/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.ConfigApplyDelegate;

abstract class AbstractConfigTest {
    private static final String D_PREFIX = "of:00000000000000";
    static final String BASIC = "basic";
    static final String JSON_LOADED = "%nJSON loaded: %s";
    static final String CHECKING_S = "   checking: %s";
    final ObjectMapper mapper = new ObjectMapper();
    final ConfigApplyDelegate delegate = config -> {};

    AbstractConfigTest() {
    }

    static void print(String fmt, Object ... params) {
        System.out.println(String.format(fmt, params));
    }

    static void print(Object o) {
        AbstractConfigTest.print("%s", o);
    }

    JsonNode getTestJson(String path) {
        try {
            InputStream is = AbstractConfigTest.class.getResourceAsStream(path);
            return this.mapper.readTree(is);
        }
        catch (IOException e) {
            Assert.fail((String)("Could not read json from: " + path + ": " + e.getMessage()));
            return null;
        }
    }

    static DeviceId dstr(String suffix) {
        return DeviceId.deviceId((String)(D_PREFIX + suffix));
    }

    final class TmpJson {
        final ObjectNode root;

        TmpJson() {
            this.root = AbstractConfigTest.this.mapper.createObjectNode();
        }

        TmpJson props(String ... keys) {
            for (String k : keys) {
                this.root.put(k, k);
            }
            return this;
        }

        TmpJson arrays(String ... keys) {
            for (String k : keys) {
                this.root.set(k, (JsonNode)AbstractConfigTest.this.mapper.createArrayNode());
            }
            return this;
        }

        TmpJson objects(String ... keys) {
            for (String k : keys) {
                this.root.set(k, (JsonNode)AbstractConfigTest.this.mapper.createObjectNode());
            }
            return this;
        }

        ObjectNode node() {
            return this.root;
        }
    }
}

