/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.packet.EthType;
import org.onlab.packet.IpAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.config.ConfigApplyDelegate;
import org.onosproject.net.config.basics.BasicHostConfig;

public class BasicHostConfigTest {
    @Test
    public void testConstruction() {
        BasicHostConfig config = new BasicHostConfig();
        ConfigApplyDelegate delegate = configApply -> {};
        ObjectMapper mapper = new ObjectMapper();
        HostId hostId = NetTestTools.hid("12:34:56:78:90:ab/1");
        IpAddress ip1 = IpAddress.valueOf((String)"1.1.1.1");
        IpAddress ip2 = IpAddress.valueOf((String)"1.1.1.2");
        IpAddress ip3 = IpAddress.valueOf((String)"1.1.1.3");
        ImmutableSet ips = ImmutableSet.of((Object)ip1, (Object)ip2, (Object)ip3);
        HostLocation loc1 = new HostLocation(NetTestTools.connectPoint("d1", 1), System.currentTimeMillis());
        HostLocation loc2 = new HostLocation(NetTestTools.connectPoint("d2", 2), System.currentTimeMillis());
        ImmutableSet locs = ImmutableSet.of((Object)loc1, (Object)loc2);
        HostLocation loc3 = new HostLocation(NetTestTools.connectPoint("d3", 1), System.currentTimeMillis());
        HostLocation loc4 = new HostLocation(NetTestTools.connectPoint("d4", 2), System.currentTimeMillis());
        ImmutableSet auxLocations = ImmutableSet.of((Object)loc3, (Object)loc4);
        VlanId vlanId = VlanId.vlanId((short)10);
        EthType ethType = EthType.EtherType.lookup((short)-30552).ethType();
        config.init((Object)hostId, "KEY", (JsonNode)JsonNodeFactory.instance.objectNode(), mapper, delegate);
        config.setIps((Set)ips).setLocations((Set)locs).setAuxLocations((Set)auxLocations).setInnerVlan(vlanId).setOuterTpid(ethType);
        MatcherAssert.assertThat((Object)config.isValid(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)config.name(), (Matcher)Matchers.is((Object)"-"));
        MatcherAssert.assertThat((Object)config.ipAddresses(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)config.ipAddresses(), (Matcher)Matchers.hasItems((Object[])new IpAddress[]{ip1, ip2, ip3}));
        MatcherAssert.assertThat((Object)config.locations(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)config.locations(), (Matcher)Matchers.hasItems((Object[])new HostLocation[]{loc1, loc2}));
        MatcherAssert.assertThat((Object)config.auxLocations(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)config.auxLocations(), (Matcher)Matchers.hasItems((Object[])new HostLocation[]{loc3, loc4}));
        MatcherAssert.assertThat((Object)config.innerVlan(), (Matcher)Matchers.is((Object)vlanId));
        MatcherAssert.assertThat((Object)config.outerTpid(), (Matcher)Matchers.is((Object)ethType));
    }
}

