/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.meter;

import com.google.common.testing.EqualsTester;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterCellId;
import org.onosproject.net.meter.MeterId;
import org.onosproject.net.meter.MeterOperation;
import org.onosproject.net.meter.MeterState;

public class MeterOperationTest {
    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutableBaseClass(MeterOperation.class);
    }

    @Test
    public void testEquality() {
        TestMeter m1 = new TestMeter();
        TestMeter m2 = new TestMeter();
        MeterOperation op1 = new MeterOperation((Meter)m1, MeterOperation.Type.ADD);
        MeterOperation sameAsOp1 = new MeterOperation((Meter)m1, MeterOperation.Type.ADD);
        MeterOperation op2 = new MeterOperation((Meter)m2, MeterOperation.Type.ADD);
        new EqualsTester().addEqualityGroup(new Object[]{op1, sameAsOp1}).addEqualityGroup(new Object[]{op2}).testEquals();
    }

    @Test
    public void testConstruction() {
        TestMeter m1 = new TestMeter();
        MeterOperation op = new MeterOperation((Meter)m1, MeterOperation.Type.ADD);
        MatcherAssert.assertThat((Object)op.meter(), (Matcher)Matchers.is((Object)m1));
    }

    private static final class TestMeter
    implements Meter {
        private TestMeter() {
        }

        public DeviceId deviceId() {
            return null;
        }

        public MeterId id() {
            return null;
        }

        public MeterCellId meterCellId() {
            return null;
        }

        public ApplicationId appId() {
            return null;
        }

        public Meter.Unit unit() {
            return null;
        }

        public boolean isBurst() {
            return false;
        }

        public Collection<Band> bands() {
            return null;
        }

        public MeterState state() {
            return null;
        }

        public long life() {
            return 0L;
        }

        public long referenceCount() {
            return 0L;
        }

        public long packetsSeen() {
            return 0L;
        }

        public long bytesSeen() {
            return 0L;
        }
    }
}

