/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.alarm;

import com.google.common.testing.EqualsTester;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.alarm.AlarmEntityId;

public class AlarmEntityIdTest {
    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(AlarmEntityId.class);
    }

    @Test
    public void string() {
        Assert.assertEquals((Object)"och:foo", (Object)AlarmEntityId.alarmEntityId((String)"och:foo").toString());
    }

    @Test
    public void basics() {
        new EqualsTester().addEqualityGroup(new Object[]{AlarmEntityId.alarmEntityId((String)"och:foo"), AlarmEntityId.alarmEntityId((String)"och:foo")}).addEqualityGroup(new Object[]{AlarmEntityId.alarmEntityId((String)"och:bar")}).testEquals();
    }

    @Test
    public void validSchemaPermitted() {
        AlarmEntityId.alarmEntityId((String)"none:foo");
        AlarmEntityId.alarmEntityId((String)"port:foo");
        AlarmEntityId.alarmEntityId((String)"och:foo");
        AlarmEntityId.alarmEntityId((String)"other:foo");
    }

    @Test(expected=IllegalArgumentException.class)
    public void verifyUnexpectedSchemaRejected() {
        AlarmEntityId.alarmEntityId((String)"junk:foo");
    }

    @Test(expected=IllegalArgumentException.class)
    public void verifyCorruptSchemaRejected() {
        AlarmEntityId.alarmEntityId((String)"other:");
    }
}

