/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.topo;

import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.PortNumber;
import org.onosproject.net.driver.Behaviour;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.ui.AbstractUiTest;
import org.onosproject.ui.model.topo.UiLinkId;
import org.onosproject.ui.topo.BiLink;
import org.onosproject.ui.topo.BiLinkMap;
import org.onosproject.ui.topo.LinkHighlight;

public abstract class BiLinkTestBase
extends AbstractUiTest {
    protected static final DeviceId DEV_A_ID = DeviceId.deviceId((String)"device-A");
    protected static final DeviceId DEV_B_ID = DeviceId.deviceId((String)"device-B");
    protected static final PortNumber PORT_1 = PortNumber.portNumber((long)1L);
    protected static final PortNumber PORT_2 = PortNumber.portNumber((long)2L);
    protected static final ConnectPoint CP_A1 = new ConnectPoint((ElementId)DEV_A_ID, PORT_1);
    protected static final ConnectPoint CP_B2 = new ConnectPoint((ElementId)DEV_B_ID, PORT_2);
    protected static final LinkKey KEY_AB = LinkKey.linkKey((ConnectPoint)CP_A1, (ConnectPoint)CP_B2);
    protected static final LinkKey KEY_BA = LinkKey.linkKey((ConnectPoint)CP_B2, (ConnectPoint)CP_A1);
    protected static final Link LINK_AB = new FakeLink(CP_A1, CP_B2);
    protected static final Link LINK_BA = new FakeLink(CP_B2, CP_A1);

    protected static class ConcreteLinkMap
    extends BiLinkMap<ConcreteLink> {
        protected ConcreteLinkMap() {
        }

        public ConcreteLink create(LinkKey key, Link link) {
            return new ConcreteLink(key, link);
        }
    }

    protected static class ConcreteLink
    extends BiLink {
        public ConcreteLink(LinkKey key, Link link) {
            super(key, link);
        }

        public ConcreteLink(UiLinkId uiLinkId) {
            super(uiLinkId);
        }

        public LinkHighlight highlight(Enum<?> type) {
            return null;
        }
    }

    protected static class FakeLink
    implements Link {
        private final ConnectPoint src;
        private final ConnectPoint dst;

        FakeLink(ConnectPoint src, ConnectPoint dst) {
            this.src = src;
            this.dst = dst;
        }

        public ConnectPoint src() {
            return this.src;
        }

        public ConnectPoint dst() {
            return this.dst;
        }

        public Link.Type type() {
            return null;
        }

        public Link.State state() {
            return null;
        }

        public boolean isExpected() {
            return false;
        }

        public Annotations annotations() {
            return null;
        }

        public ProviderId providerId() {
            return null;
        }

        public <B extends Behaviour> B as(Class<B> projectionClass) {
            return null;
        }

        public <B extends Behaviour> boolean is(Class<B> projectionClass) {
            return false;
        }
    }
}

