/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.inbandtelemetry;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.TpPort;

@Beta
public final class IntDeviceConfig {
    private final IpAddress collectorIp;
    private final TpPort collectorPort;
    private final MacAddress collectorNextHopMac;
    private final IpAddress sinkIp;
    private final MacAddress sinkMac;
    private final TelemetrySpec spec;
    private boolean enabled;

    private IntDeviceConfig(IpAddress collectorIp, TpPort collectorPort, MacAddress collectorNextHopMac, IpAddress sinkIp, MacAddress sinkMac, TelemetrySpec spec, boolean enabled) {
        this.collectorIp = collectorIp;
        this.collectorPort = collectorPort;
        this.collectorNextHopMac = collectorNextHopMac;
        this.sinkIp = sinkIp;
        this.sinkMac = sinkMac;
        this.spec = spec;
        this.enabled = enabled;
    }

    public IpAddress collectorIp() {
        return this.collectorIp;
    }

    public TpPort collectorPort() {
        return this.collectorPort;
    }

    public MacAddress collectorNextHopMac() {
        return this.collectorNextHopMac;
    }

    public IpAddress sinkIp() {
        return this.sinkIp;
    }

    public MacAddress sinkMac() {
        return this.sinkMac;
    }

    public TelemetrySpec spec() {
        return this.spec;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IpAddress collectorIp;
        private TpPort collectorPort;
        private MacAddress collectorNextHopMac;
        private IpAddress sinkIp;
        private MacAddress sinkMac;
        private TelemetrySpec spec = TelemetrySpec.INT;
        private boolean enabled = false;

        public Builder withCollectorIp(IpAddress collectorIp) {
            this.collectorIp = collectorIp;
            return this;
        }

        public Builder withCollectorPort(TpPort collectorPort) {
            this.collectorPort = collectorPort;
            return this;
        }

        public Builder withCollectorNextHopMac(MacAddress collectorNextHopMac) {
            this.collectorNextHopMac = collectorNextHopMac;
            return this;
        }

        public Builder withSinkIp(IpAddress sinkIp) {
            this.sinkIp = sinkIp;
            return this;
        }

        public Builder withSinkMac(MacAddress sinkMac) {
            this.sinkMac = sinkMac;
            return this;
        }

        public Builder withTelemetrySpec(TelemetrySpec spec) {
            this.spec = spec;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public IntDeviceConfig build() {
            Preconditions.checkNotNull((Object)this.collectorIp, (Object)"Collector IP should be specified.");
            Preconditions.checkNotNull((Object)this.collectorPort, (Object)"Collector port number should be specified.");
            Preconditions.checkNotNull((Object)this.collectorNextHopMac, (Object)"Next hop MAC address for report packets should be provided.");
            Preconditions.checkNotNull((Object)this.sinkIp, (Object)"Sink IP address for report packets should be specified.");
            Preconditions.checkNotNull((Object)this.sinkMac, (Object)"Sink MAC address for report packets should be specified.");
            return new IntDeviceConfig(this.collectorIp, this.collectorPort, this.collectorNextHopMac, this.sinkIp, this.sinkMac, this.spec, this.enabled);
        }
    }

    public static enum TelemetrySpec {
        INT,
        IOAM;

    }
}

